/**
 * @module node-opcua-server
 */
import { EventEmitter } from "events";
import { OPCUACertificateManager } from "node-opcua-certificate-manager";
import { Certificate, PrivateKey } from "node-opcua-crypto/web";
import { MessageSecurityMode, SecurityPolicy, ServerSecureChannelLayer, ServerSecureChannelParent } from "node-opcua-secure-channel";
import { UserTokenType } from "node-opcua-service-endpoints";
import { EndpointDescription } from "node-opcua-service-endpoints";
import { ApplicationDescription } from "node-opcua-service-endpoints";
import { IHelloAckLimits } from "node-opcua-transport";
export interface OPCUAServerEndPointOptions {
    /**
     * the tcp port
     */
    port: number;
    /**
     * the tcp host
     */
    host?: string;
    /**
     * the DER certificate chain
     */
    certificateChain: Certificate;
    /**
     * privateKey
     */
    privateKey: PrivateKey;
    certificateManager: OPCUACertificateManager;
    /**
     *  the default secureToken lifetime @default=60000
     */
    defaultSecureTokenLifetime?: number;
    /**
     * the maximum number of connection allowed on the TCP server socket
     * @default 20
     */
    maxConnections?: number;
    /**
     *  the  timeout for the TCP HEL/ACK transaction (in ms)
     *  @default 30000
     */
    timeout?: number;
    serverInfo: ApplicationDescription;
    objectFactory?: any;
    transportSettings?: IServerTransportSettings;
}
export interface IServerTransportSettings {
    adjustTransportLimits: (hello: IHelloAckLimits) => IHelloAckLimits;
}
export interface EndpointDescriptionParams {
    restricted?: boolean;
    allowUnsecurePassword?: boolean;
    resourcePath?: string;
    alternateHostname?: string[];
    hostname: string;
    securityPolicies: SecurityPolicy[];
    userTokenTypes: UserTokenType[];
}
export interface AddStandardEndpointDescriptionsParam {
    allowAnonymous?: boolean;
    disableDiscovery?: boolean;
    securityModes?: MessageSecurityMode[];
    restricted?: boolean;
    allowUnsecurePassword?: boolean;
    resourcePath?: string;
    alternateHostname?: string[];
    hostname?: string;
    securityPolicies?: SecurityPolicy[];
    userTokenTypes?: UserTokenType[];
}
/**
 * OPCUAServerEndPoint a Server EndPoint.
 * A sever end point is listening to one port
 * note:
 *   see OPCUA Release 1.03 part 4 page 108 7.1 ApplicationDescription
 */
export declare class OPCUAServerEndPoint extends EventEmitter implements ServerSecureChannelParent {
    /**
     * the tcp port
     */
    port: number;
    host: string | undefined;
    certificateManager: OPCUACertificateManager;
    defaultSecureTokenLifetime: number;
    maxConnections: number;
    timeout: number;
    bytesWrittenInOldChannels: number;
    bytesReadInOldChannels: number;
    transactionsCountOldChannels: number;
    securityTokenCountOldChannels: number;
    serverInfo: ApplicationDescription;
    objectFactory: any;
    _on_new_channel?: (channel: ServerSecureChannelLayer) => void;
    _on_close_channel?: (channel: ServerSecureChannelLayer) => void;
    _on_connectionRefused?: (socketData: any) => void;
    _on_openSecureChannelFailure?: (socketData: any, channelData: any) => void;
    private _certificateChain;
    private _privateKey;
    private _channels;
    private _server?;
    private _endpoints;
    private _listen_callback?;
    private _started;
    private _counter;
    private _policy_deduplicator;
    private transportSettings?;
    constructor(options: OPCUAServerEndPointOptions);
    dispose(): void;
    toString(): string;
    getChannels(): ServerSecureChannelLayer[];
    /**
     * Returns the X509 DER form of the server certificate
     */
    getCertificate(): Certificate;
    /**
     * Returns the X509 DER form of the server certificate
     */
    getCertificateChain(): Certificate;
    /**
     * the private key
     */
    getPrivateKey(): PrivateKey;
    /**
     * The number of active channel on this end point.
     */
    get currentChannelCount(): number;
    /**
     */
    getEndpointDescription(securityMode: MessageSecurityMode, securityPolicy: SecurityPolicy, endpointUrl: string | null): EndpointDescription | null;
    addEndpointDescription(securityMode: MessageSecurityMode, securityPolicy: SecurityPolicy, options: EndpointDescriptionParams): void;
    addRestrictedEndpointDescription(options: EndpointDescriptionParams): void;
    addStandardEndpointDescriptions(options?: AddStandardEndpointDescriptionsParam): void;
    /**
     * returns the list of end point descriptions.
     */
    endpointDescriptions(): EndpointDescription[];
    /**
     */
    listen(callback: (err?: Error) => void): void;
    killClientSockets(callback: (err?: Error) => void): void;
    suspendConnection(callback: (err?: Error) => void): void;
    restoreConnection(callback: (err?: Error) => void): void;
    abruptlyInterruptChannels(): void;
    /**
     */
    shutdown(callback: (err?: Error) => void): void;
    /**
     */
    start(callback: (err?: Error) => void): void;
    get bytesWritten(): number;
    get bytesRead(): number;
    get transactionsCount(): number;
    get securityTokenCount(): number;
    get activeChannelCount(): number;
    private _dump_statistics;
    private _setup_server;
    private _on_client_connection;
    private _preregisterChannel;
    private _un_pre_registerChannel;
    /**
     * @private
     */
    private _registerChannel;
    /**
     */
    private _unregisterChannel;
    private _end_listen;
    /**
     *  shutdown_channel
     * @param channel
     * @param inner_callback
     */
    private shutdown_channel;
    /**
     * @private
     */
    private _prevent_DDOS_Attack;
}
export interface EndpointDescriptionEx extends EndpointDescription {
    _parent: OPCUAServerEndPoint;
    restricted: boolean;
}
