/**
 * @module node-opcua-server
 */
import { EventEmitter } from "events";
import { IRegisterServerManager, RegisterServerManagerStatus } from "./i_register_server_manager";
/**
 * a IRegisterServerManager that hides the server from any local discover server
 *
 */
export declare class RegisterServerManagerHidden extends EventEmitter implements IRegisterServerManager {
    discoveryServerEndpointUrl: string;
    constructor(options?: {});
    stop(): Promise<void>;
    start(): Promise<void>;
    dispose(): void;
    getState(): RegisterServerManagerStatus;
}
