"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractEventFields = extractEventFields;
const node_opcua_service_filter_1 = require("node-opcua-service-filter");
const node_opcua_service_filter_2 = require("node-opcua-service-filter");
//
/**

 * extract a array of eventFields from a event node, matching the selectClauses
 * @param selectClauses
 * @param eventData : a pseudo Node that provides a browse Method and a readValue(nodeId)
 */
function extractEventFields(sessionContext, selectClauses, eventData) {
    const context = new node_opcua_service_filter_2.FilterContextOnAddressSpace(sessionContext, eventData);
    return (0, node_opcua_service_filter_1.extractEventFieldsBase)(context, selectClauses);
}
//# sourceMappingURL=extract_event_fields.js.map