import { OPCUACertificateManager } from "node-opcua-certificate-manager";
import { IOPCUASecureObjectOptions, OPCUASecureObject } from "node-opcua-common";
import { Message, ServerSecureChannelLayer } from "node-opcua-secure-channel";
import { ApplicationType } from "node-opcua-service-endpoints";
import { ApplicationDescription } from "node-opcua-service-endpoints";
import { ServiceFault } from "node-opcua-service-secure-channel";
import { StatusCode } from "node-opcua-status-code";
import { ApplicationDescriptionOptions } from "node-opcua-types";
import { EndpointDescription } from "node-opcua-types";
import { OPCUAServerEndPoint } from "./server_end_point";
/**
 *
 */
export interface OPCUABaseServerOptions extends IOPCUASecureObjectOptions {
    /**
     * the information used in the end point description
     */
    serverInfo?: ApplicationDescriptionOptions;
    /**
     * the server Certificate Manager
     */
    serverCertificateManager?: OPCUACertificateManager;
}
export declare class OPCUABaseServer extends OPCUASecureObject {
    static makeServiceFault: typeof makeServiceFault;
    /**
     * The type of server
     */
    get serverType(): ApplicationType;
    serverInfo: ApplicationDescription;
    endpoints: OPCUAServerEndPoint[];
    readonly serverCertificateManager: OPCUACertificateManager;
    capabilitiesForMDNS: string[];
    protected _preInitTask: any[];
    protected options: OPCUABaseServerOptions;
    constructor(options?: OPCUABaseServerOptions);
    protected createDefaultCertificate(): Promise<void>;
    initializeCM(): Promise<void>;
    /**
     * start all registered endPoint, in parallel, and call done when all endPoints are listening.
     */
    start(done: (err?: Error | null) => void): void;
    protected performPreInitialization(): Promise<void>;
    protected startAsync(): Promise<void>;
    /**
     * shutdown all server endPoints
     */
    shutdown(done: (err?: Error) => void): void;
    shutdownChannels(): Promise<void>;
    shutdownChannels(callback: (err?: Error | null) => void): void;
    /**
     * @private
     */
    on_request(message: Message, channel: ServerSecureChannelLayer): void;
    /**
     * @private
     */
    _get_endpoints(endpointUrl?: string | null): EndpointDescription[];
    /**
     * get one of the possible endpointUrl
     */
    getEndpointUrl(): string;
    getDiscoveryUrls(): string[];
    getServers(channel: ServerSecureChannelLayer): ApplicationDescription[];
    /**
     * set all the end point into a state where they do not accept further connections
     *
     * note:
     *     this method is useful for testing purpose
     *
     */
    suspendEndPoints(): Promise<void>;
    suspendEndPoints(callback: (err?: Error) => void): void;
    /**
     * set all the end point into a state where they do accept connections
     * note:
     *    this method is useful for testing purpose
     */
    resumeEndPoints(): Promise<void>;
    resumeEndPoints(callback: (err?: Error) => void): void;
    protected prepare(message: Message, channel: ServerSecureChannelLayer): void;
    /**
     * @private
     */
    protected _on_GetEndpointsRequest(message: Message, channel: ServerSecureChannelLayer): void;
    /**
     * @private
     */
    protected _on_FindServersRequest(message: Message, channel: ServerSecureChannelLayer): void;
    /**
     * returns a array of currently active channels
     */
    protected getChannels(): ServerSecureChannelLayer[];
}
/**
 * construct a service Fault response
 */
declare function makeServiceFault(statusCode: StatusCode, messages: string[]): ServiceFault;
export {};
