/**
 * @module node-opcua-server-discovery
 */
import { Message, MessageSecurityMode, SecurityPolicy, ServerSecureChannelLayer } from "node-opcua-secure-channel";
import { OPCUABaseServer, OPCUABaseServerOptions } from "node-opcua-server";
import { BonjourHolder, MdnsDiscoveryConfiguration, RegisteredServer } from "node-opcua-service-discovery";
import { ApplicationDescription } from "node-opcua-service-endpoints";
import { ApplicationDescriptionOptions } from "node-opcua-service-endpoints";
import { MDNSResponder } from "./mdns_responder";
export interface OPCUADiscoveryServerOptions extends OPCUABaseServerOptions {
    certificateFile?: string;
    port?: number;
    alternateHostname?: string[];
    securityPolicies?: SecurityPolicy[];
    securityModes?: MessageSecurityMode[];
    hostname?: string;
}
interface RegisteredServerExtended extends RegisteredServer {
    bonjourHolder: BonjourHolder;
    serverInfo: ApplicationDescriptionOptions;
    discoveryConfiguration?: MdnsDiscoveryConfiguration[];
}
type RegisterServerMap = Map<string, RegisteredServerExtended>;
export interface OPCUADiscoveryServer {
    on(eventName: "onUnregisterServer", eventHandler: (server: RegisteredServer, forced: boolean) => void): this;
    on(eventName: "onRegisterServer", eventHandler: (server: RegisteredServer, firstTime: boolean) => void): this;
    once(eventName: "onUnregisterServer", eventHandler: (server: RegisteredServer, forced: boolean) => void): this;
    once(eventName: "onRegisterServer", eventHandler: (server: RegisteredServer, firstTime: boolean) => void): this;
}
export declare class OPCUADiscoveryServer extends OPCUABaseServer {
    #private;
    private mDnsLDSAnnouncer?;
    mDnsResponder?: MDNSResponder;
    readonly registeredServers: RegisterServerMap;
    private _delayInit?;
    constructor(options: OPCUADiscoveryServerOptions);
    start(): Promise<void>;
    shutdown(): Promise<void>;
    /**
     * returns the number of registered servers
     */
    get registeredServerCount(): number;
    getServers(channel: ServerSecureChannelLayer): ApplicationDescription[];
    protected _on_RegisterServer2Request(message: Message, channel: ServerSecureChannelLayer): void;
    protected _on_RegisterServerRequest(message: Message, channel: ServerSecureChannelLayer): void;
    protected _on_FindServersOnNetworkRequest(message: Message, channel: ServerSecureChannelLayer): void;
}
export {};
