"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyMessageChunkSignatureForTest = exports.makeMessageChunkSignatureForTest = void 0;
exports.construct_verifyMessageChunkSignatureForTest = construct_verifyMessageChunkSignatureForTest;
const fs_1 = __importDefault(require("fs"));
require("should");
const node_opcua_assert_1 = require("node-opcua-assert");
const web_1 = require("node-opcua-crypto/web");
const node_opcua_crypto_1 = require("node-opcua-crypto");
// tslint:disable:no-var-requires
const { getFixture } = require("node-opcua-test-fixtures");
function construct_makeMessageChunkSignatureForTest() {
    const privateKey = (0, node_opcua_crypto_1.readPrivateKey)(getFixture("certs/server_key_1024.pem"));
    return (chunk) => {
        const options = {
            algorithm: "RSA-SHA256",
            privateKey,
            signatureLength: 128
        };
        const buf = (0, web_1.makeMessageChunkSignature)(chunk, options); // Buffer
        (0, node_opcua_assert_1.assert)(buf instanceof Buffer, "expecting a Buffer");
        return buf;
    };
}
exports.makeMessageChunkSignatureForTest = construct_makeMessageChunkSignatureForTest();
function construct_verifyMessageChunkSignatureForTest() {
    const publicKey = fs_1.default.readFileSync(getFixture("certs/server_public_key_1024.pub")).toString("utf-8");
    return (chunk) => {
        (0, node_opcua_assert_1.assert)(chunk instanceof Buffer);
        const options = {
            algorithm: "RSA-SHA256",
            publicKey,
            signatureLength: 128
        };
        return (0, web_1.verifyChunkSignature)(chunk, options);
    };
}
exports.verifyMessageChunkSignatureForTest = construct_verifyMessageChunkSignatureForTest();
//# sourceMappingURL=signature_helpers.js.map