"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decompose_message_body_in_chunks = decompose_message_body_in_chunks;
const node_opcua_assert_1 = require("node-opcua-assert");
const source_1 = require("../source");
const node_opcua_chunkmanager_1 = require("node-opcua-chunkmanager");
/**

 *
 * @param messageBody
 * @param msgType
 * @param chunkSize
 * @return {Array}
 *
 * wrap a message body into one or more messageChunks
 * (  use this method to build fake data blocks in tests)
 */
function decompose_message_body_in_chunks(messageBody, msgType, chunkSize) {
    (0, node_opcua_assert_1.assert)(chunkSize > 24, "expecting chunkSize");
    (0, node_opcua_assert_1.assert)(msgType.length === 3, " invalid msgType " + msgType);
    (0, node_opcua_assert_1.assert)(messageBody instanceof Buffer && messageBody.length > 0, " invalid buffer");
    const sequenceNumberGenerator = new source_1.SequenceNumberGenerator();
    const channelId = 10;
    const options = {
        channelId,
        chunkSize,
        cipherBlockSize: 0,
        plainBlockSize: 0,
        requestId: 36,
        sequenceHeaderSize: 0,
        signatureLength: 0,
    };
    const securityHeader = msgType == "OPN"
        ? new source_1.AsymmetricAlgorithmSecurityHeader({ securityPolicyUri: source_1.SecurityPolicy.None })
        : new source_1.SymmetricAlgorithmSecurityHeader();
    const mode = node_opcua_chunkmanager_1.Mode.None;
    const msgChunkManager = new source_1.SecureMessageChunkManager(mode, msgType, channelId, options, securityHeader, sequenceNumberGenerator);
    const chunks = [];
    msgChunkManager.on("chunk", (chunk) => {
        if (chunk) {
            (0, node_opcua_assert_1.assert)(chunk.length > 0);
            chunks.push(chunk);
        }
    });
    msgChunkManager.write(messageBody);
    msgChunkManager.end();
    (0, node_opcua_assert_1.assert)(chunks.length > 0, "decompose_message_body_in_chunks: must produce at least one chunk");
    return chunks;
}
//# sourceMappingURL=decompose_message_body_in_chunks.js.map