import { NodeId, NodeIdLike } from "node-opcua-nodeid";
import { BrowsePath } from "node-opcua-service-translate-browse-path";
import { QualifiedNameLike } from "node-opcua-data-model";
import { IBasicSessionAsync } from "./basic_session_interface";
export declare function findInTypeOrSuperType(session: IBasicSessionAsync, browsePath: BrowsePath): Promise<{
    nodeId: NodeId;
} | {
    nodeId: null;
    err: Error;
}>;
/**
 *
 * find a MethodId in a object or in its super type
 *
 * note:
 *   - methodName is a browse name and may therefore be prefixed with a namespace index.
 *   - if method is not found on the object specified by nodeId, then the findMethodId will
 *     recursively browse up the hierarchy of object typeDefinition Node
 *     until it reaches the root type. and try to find the first method that matches the
 *     provided name.
 *
 * @param session
 * @param nodeId     the nodeId of the object to find
 * @param methodName the method name to find prefixed with a namespace index (unless ns=0)
 *                   ( e.g "Add" or "Add" or "1:BumpCounter" )
 */
export declare function findMethodId(session: IBasicSessionAsync, nodeId: NodeIdLike, methodName: QualifiedNameLike): Promise<{
    methodId: NodeId;
} | {
    methodId: null;
    err: Error;
}>;
