"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findSuperType = findSuperType;
exports.findBasicDataType = findBasicDataType;
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_service_browse_1 = require("node-opcua-service-browse");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const resultMask = (0, node_opcua_data_model_1.makeResultMask)("ReferenceType");
const hasSubtypeNodeId = (0, node_opcua_nodeid_1.makeNodeId)(node_opcua_constants_1.ReferenceTypeIds.HasSubtype);
async function findSuperType(session, dataTypeId) {
    // let's browse for the SuperType of this object
    const nodeToBrowse = new node_opcua_service_browse_1.BrowseDescription({
        browseDirection: node_opcua_service_browse_1.BrowseDirection.Inverse,
        includeSubtypes: false,
        nodeId: dataTypeId,
        referenceTypeId: hasSubtypeNodeId,
        resultMask
    });
    const browseResult = await session.browse(nodeToBrowse);
    browseResult.references = browseResult.references || /* istanbul ignore next */ [];
    const baseDataType = browseResult.references[0].nodeId;
    return baseDataType;
}
async function findBasicDataType(session, dataTypeId) {
    if (dataTypeId.identifierType === node_opcua_nodeid_1.NodeIdType.NUMERIC && dataTypeId.value === node_opcua_constants_1.DataTypeIds.Enumeration) {
        // see https://reference.opcfoundation.org/v104/Core/docs/Part3/8.40/
        return node_opcua_variant_1.DataType.Int32;
    }
    if (dataTypeId.identifierType === node_opcua_nodeid_1.NodeIdType.NUMERIC && dataTypeId.value <= node_opcua_variant_1.DataType.DiagnosticInfo) {
        // we have a well-known DataType
        const dataTypeName = node_opcua_variant_1.DataType[dataTypeId.value];
        return dataTypeId.value;
    }
    else {
        const baseDataTypeId = await findSuperType(session, dataTypeId);
        return await findBasicDataType(session, baseDataTypeId);
    }
}
//# sourceMappingURL=find_basic_datatype.js.map