import { QualifiedName } from "node-opcua-data-model";
import { NodeId, NodeIdLike } from "node-opcua-nodeid";
import { IBasicSessionBrowseAsyncMultiple, IBasicSessionBrowseAsyncSimple, IBasicSessionReadAsyncSimple } from "./basic_session_interface";
export type ISessionForExtractField = IBasicSessionBrowseAsyncSimple & IBasicSessionBrowseAsyncMultiple & IBasicSessionReadAsyncSimple;
/**
 *
 * recursively work down an node definition and find
 * the components and property ...
 * also navigate the sub
 * @param session the session
 * @param nodeId the object to investigate , could be the nodeId of a Object/Variable/ObjectType or VariableType.
 * @returns a array of {path: QualifiedName[], nodeId: NodeId}}
 *
 * @private
 */
export declare function extractFields(session: ISessionForExtractField, nodeId: NodeIdLike): Promise<{
    path: QualifiedName[];
    nodeId: NodeId;
}[]>;
export declare function simpleBrowsePathToString(bp: QualifiedName[]): string;
export declare function simpleBrowsePathsToString(simpleBrowsePathArray: QualifiedName[][]): string[];
export declare function stringPathToSimpleBrowsePath(bp: string): QualifiedName[];
