"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMonitoredItemsLimit = createMonitoredItemsLimit;
/**
 * @module node-opcua-pseudo-session
 */
const node_opcua_service_subscription_1 = require("node-opcua-service-subscription");
const node_opcua_status_code_1 = require("node-opcua-status-code");
async function createMonitoredItemsLimit(maxMonitoredItemsPerCall, session, createMonitoredItemsRequest) {
    const _session2 = session;
    if (!createMonitoredItemsRequest.itemsToCreate || createMonitoredItemsRequest.itemsToCreate.length === 0) {
        return new node_opcua_service_subscription_1.CreateMonitoredItemsResponse({
            responseHeader: {
                serviceResult: node_opcua_status_code_1.StatusCodes.Good
            },
            results: []
        });
    }
    // if server is not able to provide a maxMonitoredItemsPerCall limit, we use a default value of 1000 arbitrarily
    maxMonitoredItemsPerCall = maxMonitoredItemsPerCall > 0 ? maxMonitoredItemsPerCall : 1000;
    if (maxMonitoredItemsPerCall <= 0 ||
        !createMonitoredItemsRequest.itemsToCreate ||
        createMonitoredItemsRequest.itemsToCreate.length <= maxMonitoredItemsPerCall) {
        return _session2.createMonitoredItems(createMonitoredItemsRequest);
    }
    const n = [...(createMonitoredItemsRequest.itemsToCreate || [])];
    const response = new node_opcua_service_subscription_1.CreateMonitoredItemsResponse({
        diagnosticInfos: null,
        results: []
    });
    do {
        const c = n.splice(0, maxMonitoredItemsPerCall);
        const cmi = new node_opcua_service_subscription_1.CreateMonitoredItemsRequest({
            subscriptionId: createMonitoredItemsRequest.subscriptionId,
            timestampsToReturn: createMonitoredItemsRequest.timestampsToReturn,
            itemsToCreate: c
        });
        const r = await _session2.createMonitoredItems(cmi);
        for (const i of r.results) {
            response.results.push(i);
        }
    } while (n.length);
    return response;
}
//# sourceMappingURL=create_monitored_items_limit.js.map