"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.encode_decode_round_trip_test = encode_decode_round_trip_test;
exports.json_encode_decode_round_trip_test = json_encode_decode_round_trip_test;
// tslint:disable:no-console
// @ts-check
const chalk_1 = __importDefault(require("chalk"));
const node_opcua_binary_stream_1 = require("node-opcua-binary-stream");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_factory_1 = require("node-opcua-factory");
const node_opcua_test_helpers_1 = require("node-opcua-test-helpers");
const should_1 = __importDefault(require("should"));
const source_1 = require("../source");
function dump_block_in_debug_mode(buffer, id, options) {
    if (process.env.DEBUG) {
        console.log((0, node_opcua_debug_1.hexDump)(buffer));
        (0, source_1.analyzePacket)(buffer, id, 0, 0, options);
    }
}
function isTypedArray(v) {
    if (v && v.buffer && v.buffer instanceof ArrayBuffer) {
        return true;
    }
    return false;
}
function isArrayOrTypedArray(v) {
    return isTypedArray(v) || v instanceof Array;
}
function compare(objReloaded, obj) {
    function displayError(p, expected, actual) {
        console.log(chalk_1.default.yellow(" ---------------------------------- error in encode_decode_round_trip_test"));
        console.log(chalk_1.default.red(" key "), p);
        console.log(chalk_1.default.red(" expected "), JSON.stringify(expected));
        console.log(chalk_1.default.cyan(" actual   "), JSON.stringify(actual));
    }
    Object.keys(objReloaded).forEach((p) => {
        try {
            if (isArrayOrTypedArray(obj[p])) {
                (0, node_opcua_test_helpers_1.assert_arrays_are_equal)(objReloaded[p], obj[p]);
            }
            else {
                if (objReloaded[p] === undefined || obj[p] === undefined) {
                    return;
                }
                JSON.stringify(objReloaded[p]).should.eql(JSON.stringify(obj[p]));
            }
        }
        catch (err) {
            displayError(p, obj[p], objReloaded[p]);
            console.log(obj.toString());
            console.log(objReloaded.toString());
            // re throw exception
            throw err;
        }
    });
}
function redirectToNull(functor) {
    const old = console.log;
    if (!process.env.DEBUG) {
        // tslint:disable:no-empty
        console.log = (...args) => {
            /** */
        };
    }
    try {
        functor();
    }
    finally {
        console.log = old;
    }
}
/**

 * @param obj  : object to test ( the object must provide a binaryStoreSize,encode,decode method
 * @param [options]
 * @param callback_buffer
 * @return {*}
 */
function encode_decode_round_trip_test(obj, options, callback_buffer) {
    if (!callback_buffer && typeof options === "function") {
        callback_buffer = options;
        options = {};
    }
    callback_buffer = callback_buffer || dump_block_in_debug_mode;
    should_1.default.exist(obj);
    const size = obj.binaryStoreSize();
    const stream = new node_opcua_binary_stream_1.BinaryStream(Buffer.alloc(size));
    obj.encode(stream);
    callback_buffer(stream.buffer, obj.encodingDefaultBinary, options);
    stream.rewind();
    // reconstruct a object ( some object may not have a default Binary and should be recreated
    const expandedNodeId = obj.encodingDefaultBinary;
    const objReloaded = expandedNodeId ? (0, node_opcua_factory_1.getStandardDataTypeFactory)().constructObject(expandedNodeId) : new obj.constructor();
    objReloaded.decode(stream);
    redirectToNull(() => (0, source_1.analyze_object_binary_encoding)(obj));
    compare(objReloaded, obj);
    return objReloaded;
}
function json_encode_decode_round_trip_test(obj, options, callbackBuffer) {
    if (!callbackBuffer && typeof options === "function") {
        callbackBuffer = options;
        options = {};
    }
    callbackBuffer = callbackBuffer || dump_block_in_debug_mode;
    should_1.default.exist(obj);
    const json = JSON.stringify(obj);
    const objReloaded = JSON.parse(json);
    compare(objReloaded, obj);
    return objReloaded;
}
//# sourceMappingURL=encode_decode_round_trip_test.js.map