import { BinaryStream } from "node-opcua-binary-stream";
import { ExpandedNodeId } from "node-opcua-nodeid";
import { BaseUAObject } from "node-opcua-factory";
export interface IExtensionObject extends BaseUAObject {
    binaryStoreSize(): number;
    encode(stream: BinaryStream): void;
    decode(stream: BinaryStream): void;
    encodingDefaultBinary?: ExpandedNodeId;
    constructor: any;
}
type encode_decode_round_trip_testCallback = (buffer: Buffer, encoding: any, options: any) => void;
/**

 * @param obj  : object to test ( the object must provide a binaryStoreSize,encode,decode method
 * @param [options]
 * @param callback_buffer
 * @return {*}
 */
export declare function encode_decode_round_trip_test(obj: IExtensionObject, options?: unknown | encode_decode_round_trip_testCallback, callback_buffer?: encode_decode_round_trip_testCallback): any;
export declare function json_encode_decode_round_trip_test(obj: unknown, options: unknown, callbackBuffer?: unknown): void;
export {};
