"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compare_obj_by_encoding = compare_obj_by_encoding;
const node_opcua_binary_stream_1 = require("node-opcua-binary-stream");
const should_1 = __importDefault(require("should"));
const persist = should_1.default;
function compare_obj_by_encoding(obj1, obj2) {
    function encoded(obj) {
        const stream = new node_opcua_binary_stream_1.BinaryStream(obj.binaryStoreSize());
        obj.encode(stream);
        return stream.buffer.toString("hex");
    }
    encoded(obj1).should.eql(encoded(obj2));
    return true;
}
//# sourceMappingURL=compare_obj_by_encoding.js.map