import { UAObject } from "node-opcua-address-space-base";
import { DataType } from "node-opcua-variant";
import { UInt64, UAString } from "node-opcua-basic-types";
import { EnumInterfaceAdminStatus } from "./enum_interface_admin_status";
import { EnumInterfaceOperStatus } from "./enum_interface_oper_status";
import { UABaseDataVariable } from "./ua_base_data_variable";
import { UAAnalogUnit } from "./ua_analog_unit";
/**
 * |                |                                                            |
 * |----------------|------------------------------------------------------------|
 * |namespace       |http://opcfoundation.org/UA/                                |
 * |nodeClass       |ObjectType                                                  |
 * |typedDefinition |IetfBaseNetworkInterfaceType i=25221                        |
 * |isAbstract      |false                                                       |
 */
export interface UAIetfBaseNetworkInterface_Base {
    adminStatus: UABaseDataVariable<EnumInterfaceAdminStatus, DataType.Int32>;
    operStatus: UABaseDataVariable<EnumInterfaceOperStatus, DataType.Int32>;
    physAddress?: UABaseDataVariable<UAString, DataType.String>;
    speed: UAAnalogUnit<UInt64, DataType.UInt64>;
}
export interface UAIetfBaseNetworkInterface extends UAObject, UAIetfBaseNetworkInterface_Base {
}
