import { UAProperty } from "node-opcua-address-space-base";
import { DataType } from "node-opcua-variant";
import { NodeId } from "node-opcua-nodeid";
import { EnumPerformUpdate } from "./enum_perform_update";
import { DTEventFilter } from "./dt_event_filter";
import { DTHistoryEventFieldList } from "./dt_history_event_field_list";
import { UAAuditHistoryUpdateEvent, UAAuditHistoryUpdateEvent_Base } from "./ua_audit_history_update_event";
/**
 * |                |                                                            |
 * |----------------|------------------------------------------------------------|
 * |namespace       |http://opcfoundation.org/UA/                                |
 * |nodeClass       |ObjectType                                                  |
 * |typedDefinition |AuditHistoryEventUpdateEventType i=2999                     |
 * |isAbstract      |true                                                        |
 */
export interface UAAuditHistoryEventUpdateEvent_Base extends UAAuditHistoryUpdateEvent_Base {
    updatedNode: UAProperty<NodeId, DataType.NodeId>;
    performInsertReplace: UAProperty<EnumPerformUpdate, DataType.Int32>;
    filter: UAProperty<DTEventFilter, DataType.ExtensionObject>;
    newValues: UAProperty<DTHistoryEventFieldList[], DataType.ExtensionObject>;
    oldValues: UAProperty<DTHistoryEventFieldList[], DataType.ExtensionObject>;
}
export interface UAAuditHistoryEventUpdateEvent extends UAAuditHistoryUpdateEvent, UAAuditHistoryEventUpdateEvent_Base {
}
