import { UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTUserIdentityToken } from "./dt_user_identity_token";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |X509IdentityToken                                           |
 * | isAbstract|false                                                       |
 */
export interface DTX509IdentityToken extends DTUserIdentityToken {
    policyId: UAString;
    certificateData: Buffer;
}
export interface UDTX509IdentityToken extends ExtensionObject, DTX509IdentityToken {
}
