import { UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTUserIdentityToken } from "./dt_user_identity_token";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |UserNameIdentityToken                                       |
 * | isAbstract|false                                                       |
 */
export interface DTUserNameIdentityToken extends DTUserIdentityToken {
    policyId: UAString;
    userName: UAString;
    password: Buffer;
    encryptionAlgorithm: UAString;
}
export interface UDTUserNameIdentityToken extends ExtensionObject, DTUserNameIdentityToken {
}
