import { SByte } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |QuantityDimension                                           |
 * | isAbstract|false                                                       |
 */
export interface DTQuantityDimension extends DTStructure {
    massExponent: SByte;
    lengthExponent: SByte;
    timeExponent: SByte;
    electricCurrentExponent: SByte;
    amountOfSubstanceExponent: SByte;
    luminousIntensityExponent: SByte;
    absoluteTemperatureExponent: SByte;
    dimensionlessExponent: SByte;
}
export interface UDTQuantityDimension extends ExtensionObject, DTQuantityDimension {
}
