import { ExtensionObject } from "node-opcua-extension-object";
import { DTPublishedAction } from "./dt_published_action";
import { DTDataSetMeta } from "./dt_data_set_meta";
import { DTActionTarget } from "./dt_action_target";
import { DTActionMethod } from "./dt_action_method";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |PublishedActionMethodDataType                               |
 * | isAbstract|false                                                       |
 */
export interface DTPublishedActionMethod extends DTPublishedAction {
    requestDataSetMetaData: DTDataSetMeta;
    actionTargets: DTActionTarget[];
    actionMethods: DTActionMethod[];
}
export interface UDTPublishedActionMethod extends ExtensionObject, DTPublishedActionMethod {
}
