import { UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
import { EnumHistoryUpdate } from "./enum_history_update";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |ModificationInfo                                            |
 * | isAbstract|false                                                       |
 */
export interface DTModificationInfo extends DTStructure {
    modificationTime: Date;
    updateType: EnumHistoryUpdate;
    userName: UAString;
}
export interface UDTModificationInfo extends ExtensionObject, DTModificationInfo {
}
