import { UInt32 } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |LldpTlvType                                                 |
 * | isAbstract|false                                                       |
 */
export interface DTLldpTlv extends DTStructure {
    tlvType: UInt32;
    tlvInfo: Buffer;
}
export interface UDTLldpTlv extends ExtensionObject, DTLldpTlv {
}
