import { UInt32, UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
import { EnumManAddrIfSubtype } from "./enum_man_addr_if_subtype";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |LldpManagementAddressTxPortType                             |
 * | isAbstract|false                                                       |
 */
export interface DTLldpManagementAddressTxPort extends DTStructure {
    addressSubtype: UInt32;
    manAddress: UAString;
    txEnable: boolean;
    addrLen: UInt32;
    ifSubtype: EnumManAddrIfSubtype;
    ifId: UInt32;
}
export interface UDTLldpManagementAddressTxPort extends ExtensionObject, DTLldpManagementAddressTxPort {
}
