import { UInt32, UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
import { EnumManAddrIfSubtype } from "./enum_man_addr_if_subtype";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |LldpManagementAddressType                                   |
 * | isAbstract|false                                                       |
 */
export interface DTLldpManagementAddress extends DTStructure {
    addressSubtype: UInt32;
    address: UAString;
    ifSubtype: EnumManAddrIfSubtype;
    ifId: UInt32;
}
export interface UDTLldpManagementAddress extends ExtensionObject, DTLldpManagementAddress {
}
