import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |LinearConversionDataType                                    |
 * | isAbstract|false                                                       |
 */
export interface DTLinearConversion extends DTStructure {
    initialAddend: number;
    multiplicand: number;
    divisor: number;
    finalAddend: number;
}
export interface UDTLinearConversion extends ExtensionObject, DTLinearConversion {
}
