import { LocalizedText } from "node-opcua-data-model";
import { UInt16, UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |ActionTargetDataType                                        |
 * | isAbstract|false                                                       |
 */
export interface DTActionTarget extends DTStructure {
    actionTargetId: UInt16;
    name: UAString;
    description: LocalizedText;
}
export interface UDTActionTarget extends ExtensionObject, DTActionTarget {
}
