"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectToFile = redirectToFile;
exports.redirectToFileAsync = redirectToFileAsync;
/**
 * @module node-opcua-debug
 */
// tslint:disable:no-console
// tslint:disable:ban-types
const fs_1 = __importDefault(require("fs"));
const util_1 = require("util");
const node_opcua_assert_1 = require("node-opcua-assert");
const get_temp_filename_1 = require("./get_temp_filename");
/**

 * @param tmpFile {String} log file name to redirect console output.
 * @param actionFct  the inner function to execute
 * @param callback
 */
function redirectToFile(tmpFile, actionFct, callback) {
    let oldConsoleLog;
    (0, node_opcua_assert_1.assert)(typeof actionFct === "function");
    (0, node_opcua_assert_1.assert)(!callback || typeof callback === "function");
    const isAsync = actionFct && actionFct.length;
    const logFile = (0, get_temp_filename_1.getTempFilename)(tmpFile);
    // xx    console.log(" log_file ",log_file);
    const f = fs_1.default.createWriteStream(logFile, { flags: "w", encoding: "utf-8" });
    function _write_to_file(...args) {
        const msg = util_1.format.call(null, ...args);
        f.write(msg + "\n");
        if (typeof process === "object" && process.env.DEBUG) {
            oldConsoleLog.call(console, msg);
        }
    }
    if (!isAsync) {
        oldConsoleLog = console.log;
        console.log = _write_to_file;
        // async version
        try {
            actionFct();
            f.end(callback);
        }
        catch (err) {
            console.log = oldConsoleLog;
            console.log(" log file = ", logFile);
            console.log("redirectToFile  has intercepted an error :", err);
            // we don't want the callback anymore since we got an error
            // display file on screen  for investigation
            console.log(fs_1.default.readFileSync(logFile).toString("utf-8"));
            f.end(() => {
                if (callback) {
                    callback(err);
                }
            });
        }
        finally {
            console.log = oldConsoleLog;
        }
    }
    else {
        oldConsoleLog = console.log;
        console.log = _write_to_file;
        // async version
        actionFct((err) => {
            (0, node_opcua_assert_1.assert)(typeof callback === "function");
            console.log = oldConsoleLog;
            if (err) {
                console.log("redirectToFile  has intercepted an error");
                throw err;
            }
            f.end(callback);
        });
    }
}
function redirectToFileAsync(tmpFile, actionFct) {
    return new Promise((resolve, reject) => {
        redirectToFile(tmpFile, actionFct, (err) => (err ? reject(err) : resolve()));
    });
}
//# sourceMappingURL=redirect_to_file.js.map