"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTempFilename = getTempFilename;
/**
 * @module node-opcua-debug
 */
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
function getTempFilename(tmpFilename) {
    tmpFilename = tmpFilename || "";
    const folderOfThisFile = __dirname;
    const temporaryFolder = path_1.default.join(folderOfThisFile, "../../../tmp/");
    if (!fs_1.default.existsSync(temporaryFolder)) {
        fs_1.default.mkdirSync(temporaryFolder);
    }
    return path_1.default.normalize(path_1.default.join(temporaryFolder, tmpFilename));
}
//# sourceMappingURL=get_temp_filename.js.map