/**
 * @module node-opcua-client-proxy
 */
import { EventEmitter } from "stream";
import { NodeId } from "node-opcua-nodeid";
import { DataValue, TimestampsToReturn } from "node-opcua-data-value";
import { NodeIdLike } from "node-opcua-nodeid";
import { CreateSubscriptionRequestOptions, MonitoringParametersOptions } from "node-opcua-service-subscription";
import { IBasicSessionAsync, IBasicSessionGetArgumentDefinitionAsync } from "node-opcua-pseudo-session";
import { ReadValueIdOptions } from "node-opcua-service-read";
import { Variant } from "node-opcua-variant";
import { ProxyStateMachineType } from "./state_machine_proxy";
import { ProxyNode } from "./proxy_transition";
export interface IProxy1 {
    nodeId: NodeId;
    executableFlag?: boolean;
    __monitoredItem_execution_flag?: EventEmitter;
    __monitoredItem?: EventEmitter;
}
export interface IProxy extends EventEmitter, IProxy1 {
    dataValue: DataValue;
}
export interface IClientSubscription {
    monitor(itemToMonitor: ReadValueIdOptions, monitoringParameters: MonitoringParametersOptions, timestampToReturn: TimestampsToReturn): Promise<IClientMonitoredItemBase>;
    terminate(): Promise<void>;
    on(eventName: "terminated", eventHandler: () => void): void;
}
export interface IClientMonitoredItemBase {
    on(eventName: "changed", eventHandler: (data: DataValue | Variant[]) => void): void;
}
export interface IBasicSessionWithSubscriptionAsync extends IBasicSessionAsync, IBasicSessionGetArgumentDefinitionAsync {
    createSubscription2(options: CreateSubscriptionRequestOptions): Promise<IClientSubscription>;
}
export declare class UAProxyManager {
    #private;
    readonly session: IBasicSessionWithSubscriptionAsync;
    subscription?: IClientSubscription;
    constructor(session: IBasicSessionWithSubscriptionAsync);
    start(): Promise<void>;
    stop(): Promise<void>;
    getObject(nodeId: NodeIdLike): Promise<ProxyNode>;
    _monitor_value(proxyObject: IProxy): Promise<void>;
    _monitor_execution_flag(proxyObject: IProxy1): Promise<void>;
    getStateMachineType(nodeId: NodeIdLike): Promise<ProxyStateMachineType>;
}
