"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractConditionFields = extractConditionFields;
const node_opcua_pseudo_session_1 = require("node-opcua-pseudo-session");
async function extractConditionFields(session, conditionNodeId) {
    // conditionNodeId could be a Object of type ConditionType
    // or it could be directly a ObjectType which is a subType of ConditionType
    const p = await (0, node_opcua_pseudo_session_1.extractFields)(session, conditionNodeId);
    const fields1 = (0, node_opcua_pseudo_session_1.simpleBrowsePathsToString)(p.map((a) => a.path));
    // add this field which will always be added
    fields1.push("ConditionId");
    return fields1;
}
//# sourceMappingURL=extract_condition_fields.js.map