"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fieldsToJson = fieldsToJson;
const node_opcua_utils_1 = require("node-opcua-utils");
const node_opcua_debug_1 = require("node-opcua-debug");
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
/**
 * @private
 */
function fieldsToJson(fields, eventFields, flat) {
    function setProperty(_data, fieldName, value) {
        let name;
        if (!fieldName || value === null) {
            return;
        }
        if (!flat) {
            const f = fieldName.split(".");
            if (f.length === 1) {
                fieldName = (0, node_opcua_utils_1.lowerFirstLetter)(fieldName);
                _data[fieldName] = value;
            }
            else {
                for (let i = 0; i < f.length - 1; i++) {
                    name = (0, node_opcua_utils_1.lowerFirstLetter)(f[i]);
                    _data[name] = _data[name] || Object.create(null);
                    _data = _data[name];
                }
                name = (0, node_opcua_utils_1.lowerFirstLetter)(f[f.length - 1]);
                _data[name] = value;
            }
        }
        else {
            const name = fieldName.split(".").map(node_opcua_utils_1.lowerFirstLetter).join(".");
            _data[name] = value;
        }
    }
    if (fields.length > eventFields.length) {
        warningLog("warning fields.length !==  eventFields.length", fields.length, eventFields.length);
    }
    // use this Object.create(null) to construct an object with no prototype
    // so that we immune from prototype pollution
    const data = Object.create(null);
    if (data.__proto__) {
        throw new Error("expecting  __proto__ to be undefined");
    }
    for (let index = 0; index < fields.length; index++) {
        const variant = eventFields[index];
        setProperty(data, fields[index], variant);
    }
    return data;
}
//# sourceMappingURL=event_stuff.js.map