import { NodeId } from "node-opcua-nodeid";
import { Variant } from "node-opcua-variant";
export interface TVariant<T> extends Variant {
    value: T;
}
export interface TTwoStateStatus extends TVariant<string> {
    id: TVariant<boolean>;
}
export interface EventStuff {
    conditionId: TVariant<NodeId>;
    eventType: TVariant<NodeId>;
    eventId: TVariant<Buffer>;
    retain: TVariant<boolean>;
    activeState: TTwoStateStatus;
    ackedState: TTwoStateStatus;
    confirmedState: TTwoStateStatus;
    conditionName?: TVariant<string>;
}
/**
 * @private
 */
export declare function fieldsToJson(fields: string[], eventFields: Variant[], flat?: boolean): EventStuff;
