import { EventEmitter } from "events";
import { NodeId } from "node-opcua-nodeid";
import { StatusCode } from "node-opcua-status-code";
import { Variant } from "node-opcua-variant";
import { IBasicSessionAsync } from "node-opcua-pseudo-session";
import { EventStuff } from "./event_stuff";
export interface ClientAlarm {
    conditionId: NodeId;
    eventType: NodeId;
    fields: EventStuff;
    on(eventName: "changed", eventHandler: () => void): this;
    acknowledge(session: IBasicSessionAsync, comment: string): Promise<StatusCode>;
    confirm(session: IBasicSessionAsync, comment: string): Promise<StatusCode>;
    getField(fieldName: string): Variant | null;
}
/**
 * describes a OPCUA Alarm as seen in the client side
 */
export declare class ClientAlarm extends EventEmitter {
    conditionId: NodeId;
    eventType: NodeId;
    eventId: Buffer;
    fields: EventStuff;
    constructor(eventFields: EventStuff);
    update(eventFields: EventStuff): void;
    getRetain(): boolean;
    toString(): string;
}
