"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPercentBadData = getPercentBadData;
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_variant_1 = require("node-opcua-variant");
const common_1 = require("./common");
const calculate_bad_good_1 = require("./calculate_bad_good");
function calculatePercentBad(interval, options) {
    const { percentBad, statusCode } = (0, calculate_bad_good_1.calculateBadAndGood)(interval, options);
    const value = percentBad;
    if (statusCode.isGoodish()) {
        return new node_opcua_data_value_1.DataValue({
            sourceTimestamp: interval.startTime,
            statusCode,
            value: { dataType: node_opcua_variant_1.DataType.Double, value }
        });
    }
    return new node_opcua_data_value_1.DataValue({ sourceTimestamp: interval.startTime, statusCode, value: { dataType: node_opcua_variant_1.DataType.Null } });
}
/**Retrieve the percentage of data (0 to 100) in the interval which has Bad StatusCode. */
function getPercentBadData(node, processingInterval, startDate, endDate, callback) {
    (0, common_1.getAggregateData)(node, processingInterval, startDate, endDate, calculatePercentBad, callback);
}
//# sourceMappingURL=percent_bad.js.map