/**
 * @module node-opcua-address-space
 */
export * from "./address_space_ts";

export * from "./interfaces/state_machine/ua_state_machine_type";
export * from "./interfaces/state_machine/ua_exclusive_limit_state_machine_type_ex";
export * from "./interfaces/state_machine/ua_finite_state_machine_type";
export * from "./interfaces/state_machine/ua_program_state_machine_type";
export * from "./interfaces/state_machine/ua_shelved_state_machine_ex";

export * from "./interfaces/state_machine/ua_transition_ex";

export * from "./interfaces/ua_subscription_diagnostics_variable_ex";

export * from "./interfaces/data_access/ua_multistate_discrete_ex";
export * from "./interfaces/data_access/ua_multistate_value_discrete_ex";
export * from "./interfaces/data_access/ua_two_state_discrete_ex";
export * from "./interfaces/data_access/ua_y_array_item_ex";
export * from "./interfaces/extension_object_constructor";

export * from "./interfaces/alarms_and_conditions/condition_info_i";
export * from "./interfaces/alarms_and_conditions/condition_snapshot";
export * from "./interfaces/alarms_and_conditions/instantiate_alarm_condition_options";
export * from "./interfaces/alarms_and_conditions/instantiate_condition_options";
export * from "./interfaces/alarms_and_conditions/instantiate_exclusive_limit_alarm_options";
export * from "./interfaces/alarms_and_conditions/instantiate_limit_alarm_options";
export * from "./interfaces/alarms_and_conditions/instantiate_off_normal_alarm_options";
export * from "./interfaces/alarms_and_conditions/ua_acknowledgeable_condition_ex";
export * from "./interfaces/alarms_and_conditions/ua_alarm_condition_ex";
export * from "./interfaces/alarms_and_conditions/ua_certificate_expiration_alarm_ex";
export * from "./interfaces/alarms_and_conditions/ua_condition_ex";
export * from "./interfaces/alarms_and_conditions/ua_discrete_alarm_ex";
export * from "./interfaces/alarms_and_conditions/ua_exclusive_deviation_alarm_ex";
export * from "./interfaces/alarms_and_conditions/ua_exclusive_limit_alarm_ex";
export * from "./interfaces/alarms_and_conditions/ua_limit_alarm_ex";
export * from "./interfaces/alarms_and_conditions/ua_non_exclusive_deviation_alarm_ex";
export * from "./interfaces/alarms_and_conditions/ua_non_exclusive_limit_alarm_ex";

export * from "./interfaces/nodeset_loader_options";

export { promoteToMultiStateDiscrete } from "../src/data_access/ua_multistate_discrete_impl";
export { promoteToMultiStateValueDiscrete } from "../src/data_access/ua_multistate_value_discrete_impl";
export { promoteToTwoStateDiscrete } from "../src/data_access/ua_two_state_discrete_impl";
export { validateIsNumericDataType } from "../src/data_access/ua_multistate_value_discrete_impl";
// deprecated: validateDataType
export { validateDataType } from "../src/data_access/ua_multistate_value_discrete_impl";
export { validateDataTypeCorrectness  } from "../src/validate_data_type_correctness";
export * from "./ua_root_folder";
export * from "./ua_addin";
export * from "./ua_interface";

export * from "./session_context";
export * from "./pseudo_session";

export * from "./helpers/dump_tools";
export * from "./helpers/make_optionals_map";
export * from "./helpers/argument_list";
export * from "./helpers/call_helpers";
export * from "./helpers/ensure_secure_access";
export { adjustBrowseDirection } from "./helpers/adjust_browse_direction";
export { resolveOpaqueOnAddressSpace } from "./helpers/resolve_opaque_on_address_space";

export { ContinuationPointManager } from "./continuation_points/continuation_point_manager";
export { ensureDatatypeExtracted, ensureDatatypeExtractedWithCallback } from "./loader/ensure_datatype_extracted";

export * from "./loader/generateAddressSpaceRaw";
export * from "./loader/register_node_promoter";

export * from "./namespace";
export * from "./namespace_data_access";
export * from "../src/private_namespace";

export { instantiateCertificateExpirationAlarm } from "../src/alarms_and_conditions/ua_certificate_expiration_alarm_impl";

export { NodeIdManager, ConstructNodeIdOptions } from "../src/nodeid_manager";
export * from "../src/event_data";
export * from "./set_namespace_meta_data";

export * from "node-opcua-address-space-base";
export * from "node-opcua-nodeset-ua";
export * from "../src/nodeset_tools/construct_namespace_dependency";
