"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAddressSpaceFixture = getAddressSpaceFixture;
/**
 * @module node-opcua-address-space
 */
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
function getAddressSpaceFixture(pathname) {
    // find in nodesets folder in the first place
    const folder1 = path_1.default.join(__dirname, "../nodesets");
    if (fs_1.default.existsSync(folder1)) {
        const filename = path_1.default.join(folder1, pathname);
        if (fs_1.default.existsSync(filename)) {
            return filename;
        }
    }
    // find in  test_fixtures seconds
    let folder = path_1.default.join(__dirname, "./test_fixtures");
    if (!fs_1.default.existsSync(folder)) {
        folder = path_1.default.join(__dirname, "../test_helpers/test_fixtures");
        if (!fs_1.default.existsSync(folder)) {
            folder = path_1.default.join(__dirname, "../../test_helpers/test_fixtures");
            // istanbul ignore next
            if (!fs_1.default.existsSync(folder)) {
                // tslint:disable:no-console
                console.log(" cannot find test_fixtures folder ");
            }
        }
    }
    const filename = path_1.default.join(folder, pathname);
    // istanbul ignore next
    if (!fs_1.default.existsSync(filename)) {
        throw new Error(" cannot find fixture with name " + pathname);
    }
    return filename;
}
//# sourceMappingURL=get_address_space_fixture.js.map