import { BindExtensionObjectOptions, CloneExtraInfo, ContinuationData, VariableDataValueSetterWithCallback } from "node-opcua-address-space-base";
import { QualifiedNameLike, NodeClass, AccessLevelFlag, AttributeIds, QualifiedName } from "node-opcua-data-model";
import { DataValue, DataValueT } from "node-opcua-data-value";
import { PreciseClock } from "node-opcua-date-time";
import { ExtensionObject } from "node-opcua-extension-object";
import { NodeId, NodeIdLike } from "node-opcua-nodeid";
import { NumericRange } from "node-opcua-numeric-range";
import { StatusCode, CallbackT } from "node-opcua-status-code";
import { HistoryReadDetails, HistoryReadResult, ReadAtTimeDetails, ReadEventDetails, ReadProcessedDetails, ReadRawModifiedDetails, WriteValueOptions } from "node-opcua-types";
import { Variant, VariantLike, DataType } from "node-opcua-variant";
import { StatusCodeCallback } from "node-opcua-status-code";
import { BindVariableOptions, IVariableHistorian, TimestampGetFunc, UADataType, UAVariable, UAVariableType, CloneOptions, CloneFilter, ISessionContext, UAVariableT } from "node-opcua-address-space-base";
import { UAHistoricalDataConfiguration } from "node-opcua-nodeset-ua";
import { BaseNodeImpl, InternalBaseNodeOptions } from "./base_node_impl";
import { EnumerationInfo, IEnumItem } from "./ua_data_type_impl";
import { ConditionRefreshCache } from "./apply_condition_refresh";
export declare function adjust_accessLevel(accessLevel: string | number | null): AccessLevelFlag;
export declare function adjust_userAccessLevel(userAccessLevel: string | number | null | undefined, accessLevel: string | number | null): AccessLevelFlag | undefined;
interface UAVariableOptions extends InternalBaseNodeOptions {
    value?: any;
    dataType: NodeId | string;
    /**
     * This attribute indicates whether the Value attribute of the Variable is an array and how many dimensions the array has.
     * It may have the following values:
     *   * n > 1: the Value is an array with the specified number of dimensions.
     *   * OneDimension (1): The value is an array with one dimension.
     *   * OneOrMoreDimensions (0): The value is an array with one or more dimensions.
     *   * Scalar (−1): The value is not an array.
     *   * Any (−2): The value can be a scalar or an array with any number of dimensions.
     *   * ScalarOrOneDimension (−3): The value can be a scalar or a one dimensional array.
     *   * All DataTypes are considered to be scalar, even if they have array-like semantics like ByteString and String.
     */
    valueRank?: number;
    arrayDimensions?: null | number[];
    accessLevel?: any;
    userAccessLevel?: any;
    minimumSamplingInterval?: number;
    historizing?: number;
}
/**
 * A OPCUA Variable Node
 *
 * @class UAVariable
 * @constructor
 * @extends  BaseNode
 *  The AccessLevel Attribute is used to indicate how the Value of a Variable can be accessed (read/write) and if it
 *  contains current and/or historic data. The AccessLevel does not take any user access rights into account,
 *  i.e. although the Variable is writable this may be restricted to a certain user / user group.
 *  The AccessLevel is an 8-bit unsigned integer with the structure defined in the following table:
 *
 *  Field            Bit    Description
 *  CurrentRead      0      Indicates if the current value is readable
 *                          (0 means not readable, 1 means readable).
 *  CurrentWrite     1      Indicates if the current value is writable
 *                          (0 means not writable, 1 means writable).
 *  HistoryRead      2      Indicates if the history of the value is readable
 *                          (0 means not readable, 1 means readable).
 *  HistoryWrite     3      Indicates if the history of the value is writable (0 means not writable, 1 means writable).
 *  SemanticChange   4      Indicates if the Variable used as Property generates SemanticChangeEvents (see 9.31).
 *  Reserved         5:7    Reserved for future use. Shall always be zero.
 *
 *  The first two bits also indicate if a current value of this Variable is available and the second two bits
 *  indicates if the history of the Variable is available via the OPC UA server.
 *
 */
export declare class UAVariableImpl extends BaseNodeImpl implements UAVariable {
    readonly nodeClass = NodeClass.Variable;
    dataType: NodeId;
    private _basicDataType?;
    $extensionObject?: any;
    $set_ExtensionObject?: (newValue: ExtensionObject, sourceTimestamp: PreciseClock, cache: Set<UAVariableImpl>) => void;
    $historicalDataConfiguration?: UAHistoricalDataConfiguration;
    varHistorian?: IVariableHistorian;
    /**
     * @internal @private
     */
    $dataValue: DataValue;
    accessLevel: number;
    userAccessLevel?: number;
    valueRank: number;
    minimumSamplingInterval: number;
    historizing: boolean;
    semantic_version: number;
    arrayDimensions: null | number[];
    _timestamped_get_func?: TimestampGetFunc | null;
    _timestamped_set_func?: VariableDataValueSetterWithCallback | null;
    _get_func: any;
    _set_func: any;
    refreshFunc?: (callback: CallbackT<DataValue>) => void;
    __waiting_callbacks?: any[];
    get typeDefinitionObj(): UAVariableType;
    get typeDefinition(): NodeId;
    constructor(options: UAVariableOptions);
    private checkAccessLevelPrivate;
    private checkPermissionPrivate;
    private checkPermissionAndAccessLevelPrivate;
    isReadable(context: ISessionContext): boolean;
    isUserReadable(context: ISessionContext): boolean;
    isWritable(context: ISessionContext): boolean;
    isUserWritable(context: ISessionContext): boolean;
    canUserReadHistory(context: ISessionContext): boolean;
    canUserWriteHistorizingAttribute(context: ISessionContext): boolean;
    canUserInsertHistory(context: ISessionContext): boolean;
    canUserModifyHistory(context: ISessionContext): boolean;
    canUserDeleteHistory(context: ISessionContext): boolean;
    /**
     *
     *
     * from OPC.UA.Spec 1.02 part 4
     *  5.10.2.4 StatusCodes
     *  Table 51 defines values for the operation level statusCode contained in the DataValue structure of
     *  each values element. Common StatusCodes are defined in Table 166.
     *
     * Table 51 Read Operation Level Result Codes
     *
     * | Symbolic Id                 | Description
     * |-----------------------------|---------------------------------------------------------------------------------------------|
     * |BadNodeIdInvalid             | The syntax of the node id is not valid.|
     * |BadNodeIdUnknown            |The node id refers to a node that does not exist in the server address space.|
     * |BadAttributeIdInvalid      | BadAttributeIdInvalid The attribute is not supported for the specified node.|
     * |BadIndexRangeInvalid       | The syntax of the index range parameter is invalid.|
     * |BadIndexRangeNoData        | No data exists within the range of indexes specified.|
     * |BadDataEncodingInvalid     | The data encoding is invalid.|
     * |                           | This result is used if no dataEncoding can be applied because an Attribute other|
     * |                           | than Value was requested or the DataType of the Value Attribute is not a subtype|
     * |                           | of the Structure DataType.|
     * |BadDataEncodingUnsupported | The server does not support the requested data encoding for the node. |
     * |                           | This result is used if a dataEncoding can be applied but the passed data encoding |
     * |                           | is not known to the Server. |
     * |BadNotReadable             | The access level does not allow reading or subscribing to the Node.|
     * |BadUserAccessDenied        | User does not have permission to perform the requested operation. (table 165)|
     */
    readValue(context?: ISessionContext | null, indexRange?: NumericRange, dataEncoding?: QualifiedNameLike | null): DataValue;
    isEnumeration(): boolean;
    /**
     * return true if the DataType is of type Extension object
     * this is not taking into account the valueRank of the variable
     */
    isExtensionObject(): boolean;
    _getEnumerationInfo(): EnumerationInfo;
    asyncRefresh(oldestDate: PreciseClock, callback: CallbackT<DataValue>): void;
    asyncRefresh(oldestDate: PreciseClock): Promise<DataValue>;
    readEnumValue(): IEnumItem;
    writeEnumValue(value: string | number): void;
    readAttribute(context: ISessionContext | null, attributeId: AttributeIds, indexRange?: NumericRange, dataEncoding?: QualifiedNameLike | null): DataValue;
    getBasicDataType(): DataType;
    adjustVariant(variant: Variant): Variant;
    verifyVariantCompatibility(variant: Variant): void;
    /**
     * setValueFromSource is used to let the device sets the variable values
     * this method also records the current time as sourceTimestamp and serverTimestamp.
.     *
    * The method will raise an exception if the value is not compatible with the dataType and expected dimension
    *

    * @param variant  {Variant}
    * @param [statusCode  {StatusCode} = StatusCodes.Good]
    * @param [sourceTimestamp= Now]
    */
    setValueFromSource(variant: VariantLike, statusCode?: StatusCode, sourceTimestamp?: Date): void;
    private adjustDataValueStatusCode;
    writeValue(context: ISessionContext, dataValue: DataValue, indexRange: string | NumericRange | null, callback: StatusCodeCallback): void;
    writeValue(context: ISessionContext, dataValue: DataValue, callback: StatusCodeCallback): void;
    writeValue(context: ISessionContext, dataValue: DataValue, indexRange?: string | NumericRange | null): Promise<StatusCode>;
    writeAttribute(context: ISessionContext | null, writeValue: WriteValueOptions, callback: StatusCodeCallback): void;
    writeAttribute(context: ISessionContext | null, writeValue: WriteValueOptions): Promise<StatusCode>;
    /**

     * note:
     *     this method is overridden in address-space-data-access
     * @return {StatusCode}
     */
    checkVariantCompatibility(value: Variant): StatusCode;
    /**
     * touch the source timestamp of a Variable and cascade up the change
     * to the parent variable if any.
     */
    touchValue(optionalNow?: PreciseClock): void;
    /**
     * bind a variable with a get and set functions.
     *
     *  properties:
     *    - value: a Variant or a status code
     *    - sourceTimestamp
     *    - sourcePicoseconds
     * @param [options.timestamped_set]
     * @param [options.refreshFunc]      the variable asynchronous getter function.
     * @param [overwrite {Boolean} = false] set overwrite to true to overwrite existing binding
     * @return void
     *
     *
     * ### Providing read access to the underlying value
     *
     * #### Variation 1
     *
     * In this variation, the user provides a function that returns a Variant with the current value.
     *
     * The sourceTimestamp will be set automatically.
     *
     * The get function is called synchronously.
     *
     * @example
     *
     *
     * ```javascript
     *     ...
     *     var options =  {
     *       get : () => {
     *          return new Variant({...});
     *       },
     *       set : function(variant) {
     *          // store the variant somewhere
     *          return StatusCodes.Good;
     *       }
     *    };
     *    ...
     *    engine.bindVariable(nodeId,options):
     *    ...
     * ```
     *
     *
     * #### Variation 2:
     *
     * This variation can be used when the user wants to specify a specific '''sourceTimestamp''' associated
     * with the current value of the UAVariable.
     *
     * The provided ```timestamped_get``` function should return an object with three properties:
     * * value: containing the variant value or a error StatusCode,
     * * sourceTimestamp
     * * sourcePicoseconds
     *
     * ```javascript
     * ...
     * var myDataValue = new DataValue({
     *   value: {dataType: DataType.Double , value: 10.0},
     *   sourceTimestamp : new Date(),
     *   sourcePicoseconds: 0
     * });
     * ...
     * var options =  {
     *   timestamped_get : () => { return myDataValue;  }
     * };
     * ...
     * engine.bindVariable(nodeId,options):
     * ...
     * // record a new value
     * myDataValue.value.value = 5.0;
     * myDataValue.sourceTimestamp = new Date();
     * ...
     * ```
     *
     *
     * #### Variation 3:
     *
     * This variation can be used when the value associated with the variables requires a asynchronous function call to be
     * extracted. In this case, the user should provide an async method ```refreshFunc```.
     *
     *
     * The ```refreshFunc``` shall do whatever is necessary to fetch the most up to date version of the variable value, and
     * call the ```callback``` function when the data is ready.
     *
     *
     * The ```callback``` function follow the standard callback function signature:
     * * the first argument shall be **null** or **Error**, depending of the outcome of the fetch operation,
     * * the second argument shall be a DataValue with the new UAVariable Value,  a StatusCode, and time stamps.
     *
     *
     * Optionally, it is possible to pass a sourceTimestamp and a sourcePicoseconds value as a third and fourth arguments
     * of the callback. When sourceTimestamp and sourcePicoseconds are missing, the system will set their default value
     * to the current time..
     *
     *
     * ```javascript
     * ...
     * var options =  {
     *    refreshFunc : function(callback) {
     *      ... do_some_async_stuff_to_get_the_new_variable_value
     *      var dataValue = new DataValue({
     *          value: new Variant({...}),
     *          statusCode: StatusCodes.Good,
     *          sourceTimestamp: new Date()
     *      });
     *      callback(null,dataValue);
     *    }
     * };
     * ...
     * variable.bindVariable(nodeId,options):
     * ...
     * ```
     *
     * ### Providing write access to the underlying value
     *
     * #### Variation1 - provide a simple synchronous set function
     *
     *
     * #### Notes
     *   to do : explain return StatusCodes.GoodCompletesAsynchronously;
     *
     */
    bindVariable(options?: BindVariableOptions, overwrite?: boolean): void;
    /**

     */
    readValueAsync(context: ISessionContext | null, callback: CallbackT<DataValue>): void;
    readValueAsync(context: ISessionContext | null): Promise<DataValue>;
    getWriteMask(): number;
    getUserWriteMask(): number;
    clone(options: CloneOptions, optionalFilter?: CloneFilter, extraInfo?: CloneExtraInfo): UAVariable;
    getDataTypeNode(): UADataType;
    get dataTypeObj(): UADataType;
    checkExtensionObjectIsCorrect(extObj: ExtensionObject | ExtensionObject[] | null): boolean;
    changeDataType(newDataType: NodeIdLike, newValue?: VariantLike): void;
    /**
     * @private
     * install UAVariable to exposed th
     *
     * precondition:
     */
    installExtensionObjectVariables(): void;
    /**

     * @return {ExtensionObject}
     */
    bindExtensionObjectScalar(optionalExtensionObject?: ExtensionObject, options?: BindExtensionObjectOptions): ExtensionObject | null;
    bindExtensionObjectArray(optionalExtensionObject?: ExtensionObject[], options?: BindExtensionObjectOptions): ExtensionObject[] | null;
    bindExtensionObject(optionalExtensionObject?: ExtensionObject | ExtensionObject[], options?: BindExtensionObjectOptions): ExtensionObject | ExtensionObject[] | null;
    updateExtensionObjectPartial(partialExtensionObject?: {
        [key: string]: any;
    }): ExtensionObject;
    incrementExtensionObjectPartial(path: string | string[]): void;
    toString(): string;
    historyRead(context: ISessionContext, historyReadDetails: HistoryReadDetails | ReadRawModifiedDetails | ReadEventDetails | ReadProcessedDetails | ReadAtTimeDetails, indexRange: NumericRange | null, dataEncoding: QualifiedNameLike | null, continuationData: ContinuationData): Promise<HistoryReadResult>;
    historyRead(context: ISessionContext, historyReadDetails: HistoryReadDetails | ReadRawModifiedDetails | ReadEventDetails | ReadProcessedDetails | ReadAtTimeDetails, indexRange: NumericRange | null, dataEncoding: QualifiedNameLike | null, continuationData: ContinuationData, callback: CallbackT<HistoryReadResult>): void;
    _historyReadRaw(context: ISessionContext, historyReadRawModifiedDetails: ReadRawModifiedDetails, indexRange: NumericRange | null, dataEncoding: QualifiedNameLike | null, continuationData: ContinuationData, callback: CallbackT<HistoryReadResult>): void;
    _historyReadRawModify(context: ISessionContext, historyReadRawModifiedDetails: ReadRawModifiedDetails, indexRange: NumericRange | null, dataEncoding: QualifiedNameLike | null, continuationData: ContinuationData, callback?: CallbackT<HistoryReadResult>): any;
    _historyRead(context: ISessionContext, historyReadDetails: HistoryReadDetails | ReadRawModifiedDetails | ReadEventDetails | ReadProcessedDetails | ReadAtTimeDetails, indexRange: NumericRange | null, dataEncoding: QualifiedNameLike | null, continuationData: ContinuationData, callback: CallbackT<HistoryReadResult>): void;
    _historyPush(newDataValue: DataValue): any;
    _historyReadRawAsync(historyReadRawModifiedDetails: ReadRawModifiedDetails, maxNumberToExtract: number, isReversed: boolean, reverseDataValue: boolean, callback: CallbackT<DataValue[]>): any;
    _historyReadModify(context: ISessionContext, historyReadRawModifiedDetails: ReadRawModifiedDetails, indexRange: NumericRange | null, dataEncoding: QualifiedNameLike | null, continuationData: ContinuationData, callback: CallbackT<HistoryReadResult>): any;
    _update_startOfOnlineArchive(newDate: Date): void;
    _update_startOfArchive(newDate: Date): void;
    _validate_DataType(variantDataType: DataType): boolean;
    _internal_set_value(value: Variant): void;
    _internal_set_dataValue(dataValue: DataValue, indexRange?: NumericRange | null): void;
    /**
     * @private
     */
    _inner_replace_dataValue(dataValue: DataValue, indexRange?: NumericRange | null): void;
    _conditionRefresh(_cache?: ConditionRefreshCache): void;
    handle_semantic_changed(): void;
    private _readDataType;
    private _readValueRank;
    private _readArrayDimensions;
    private _readAccessLevel;
    private _readAccessLevelEx;
    private _readUserAccessLevel;
    private _readMinimumSamplingInterval;
    private _readHistorizing;
}
export interface UAVariableImplExtArray {
    $$variableType?: UAVariableType;
    $$dataType: UADataType;
    $$getElementBrowseName: (extObject: ExtensionObject, index: number | number[]) => QualifiedName;
    $$extensionObjectArray: ExtensionObject[];
    $$indexPropertyName: string;
}
export interface UAVariableImpl extends UAVariableImplExtArray {
}
export interface UAVariableImplT<T, DT extends DataType> extends UAVariableImpl, UAVariableT<T, DT> {
    on(): any;
    once(): any;
    readValueAsync(context: ISessionContext | null): Promise<DataValueT<T, DT>>;
    readValueAsync(context: ISessionContext | null, callback: CallbackT<DataValueT<T, DT>>): void;
    readValue(context?: ISessionContext | null, indexRange?: NumericRange, dataEncoding?: QualifiedNameLike | null): DataValueT<T, DT>;
    readValue(context?: ISessionContext | null, indexRange?: NumericRange, dataEncoding?: QualifiedNameLike | null): DataValueT<T, DT>;
    writeValue(context: ISessionContext, dataValue: DataValueT<T, DT>, indexRange: NumericRange | null, callback: StatusCodeCallback): void;
    writeValue(context: ISessionContext, dataValue: DataValueT<T, DT>, callback: StatusCodeCallback): void;
    writeValue(context: ISessionContext, dataValue: DataValueT<T, DT>, indexRange?: NumericRange | null): Promise<StatusCode>;
}
export declare class UAVariableImplT<T, DT extends DataType> extends UAVariableImpl {
}
export {};
