"use strict";
/**
 * @module node-opcua-address-space
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UAReferenceTypeImpl = void 0;
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_data_model_2 = require("node-opcua-data-model");
const node_opcua_data_model_3 = require("node-opcua-data-model");
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_variant_1 = require("node-opcua-variant");
const source_1 = require("../source");
const base_node_impl_1 = require("./base_node_impl");
const tool_isSubtypeOf_1 = require("./tool_isSubtypeOf");
const tool_isSubtypeOf_2 = require("./tool_isSubtypeOf");
const reference_impl_1 = require("./reference_impl");
const base_node_private_1 = require("./base_node_private");
const ReferenceTypeCounter = { count: 0 };
function _internal_getAllSubtypes(referenceType) {
    const addressSpace = referenceType.addressSpace;
    const possibleReferenceTypes = [];
    const hasSubtypeReferenceType = addressSpace.findReferenceType("HasSubtype");
    function _findAllSubType(referenceTypeInner) {
        possibleReferenceTypes.push(referenceTypeInner);
        (0, node_opcua_assert_1.assert)(referenceTypeInner.nodeClass === node_opcua_data_model_2.NodeClass.ReferenceType);
        const references = referenceTypeInner.findReferences(hasSubtypeReferenceType, true);
        for (const _r of references) {
            const subType = addressSpace.findReferenceType(_r.nodeId);
            _findAllSubType(subType);
        }
    }
    _findAllSubType(referenceType);
    return possibleReferenceTypes;
}
function _getAllSubtypes(ref) {
    const _cache = (0, base_node_private_1.BaseNode_getCache)(ref);
    if (!_cache._allSubTypesVersion || _cache._allSubTypesVersion < ReferenceTypeCounter.count) {
        _cache._allSubTypes = null;
    }
    if (!_cache._allSubTypes) {
        _cache._allSubTypes = _internal_getAllSubtypes(ref);
        _cache._allSubTypesVersion = ReferenceTypeCounter.count;
    }
    return _cache._allSubTypes;
}
function _internal_getSubtypeIndex(referenceType) {
    const possibleReferenceTypes = _getAllSubtypes(referenceType);
    // create a index of reference type with browseName as key for faster search
    const keys = new Map();
    for (const refType of possibleReferenceTypes) {
        keys.set(refType.nodeId.toString(), refType);
    }
    return keys;
}
function _getSubtypeIndex(referenceType) {
    const _cache = (0, base_node_private_1.BaseNode_getCache)(referenceType);
    if (!_cache._subtype_idx || (_cache._subtype_idxVersion && _cache._subtype_idxVersion < ReferenceTypeCounter.count)) {
        // the cache need to be invalidated
        _cache._subtype_idx = null;
    }
    if (!_cache._subtype_idx) {
        _cache._subtype_idx = _internal_getSubtypeIndex(referenceType);
        _cache._subtype_idxVersion = ReferenceTypeCounter.count;
    }
    return _cache._subtype_idx;
}
class UAReferenceTypeImpl extends base_node_impl_1.BaseNodeImpl {
    nodeClass = node_opcua_data_model_2.NodeClass.ReferenceType;
    isAbstract;
    symmetric;
    inverseName;
    get subtypeOfObj() {
        return tool_isSubtypeOf_2.get_subtypeOfObj.call(this);
    }
    get subtypeOf() {
        return tool_isSubtypeOf_2.get_subtypeOf.call(this);
    }
    /**
     * returns true if self is  a super type of baseType
     */
    isSubtypeOf = (0, tool_isSubtypeOf_1.construct_isSubtypeOf)(UAReferenceTypeImpl);
    /** @deprecated - use `isSubtypeOf` instead*/
    isSupertypeOf = (0, tool_isSubtypeOf_1.construct_isSubtypeOf)(UAReferenceTypeImpl);
    /**
     * @private
     */
    _slow_isSubtypeOf = (0, tool_isSubtypeOf_1.construct_slow_isSubtypeOf)(UAReferenceTypeImpl);
    constructor(options) {
        super(options);
        this.isAbstract = options.isAbstract === undefined ? false : !!options.isAbstract;
        this.symmetric = options.symmetric === undefined ? false : !!options.symmetric;
        // Note: Inverse name is not required anymore in 1.0.4
        this.inverseName = (0, node_opcua_data_model_1.coerceLocalizedText)(options.inverseName || this.browseName.name);
        ReferenceTypeCounter.count += 1;
    }
    readAttribute(context, attributeId) {
        (0, node_opcua_assert_1.assert)(!context || context instanceof source_1.SessionContext);
        const options = {};
        switch (attributeId) {
            case node_opcua_data_model_3.AttributeIds.IsAbstract:
                options.value = { dataType: node_opcua_variant_1.DataType.Boolean, value: !!this.isAbstract };
                options.statusCode = node_opcua_status_code_1.StatusCodes.Good;
                break;
            case node_opcua_data_model_3.AttributeIds.Symmetric:
                options.value = { dataType: node_opcua_variant_1.DataType.Boolean, value: !!this.symmetric };
                options.statusCode = node_opcua_status_code_1.StatusCodes.Good;
                break;
            case node_opcua_data_model_3.AttributeIds.InverseName: // LocalizedText
                options.value = { dataType: node_opcua_variant_1.DataType.LocalizedText, value: this.inverseName };
                options.statusCode = node_opcua_status_code_1.StatusCodes.Good;
                break;
            default:
                return super.readAttribute(context, attributeId);
        }
        return new node_opcua_data_value_1.DataValue(options);
    }
    toString() {
        let str = "";
        str += this.isAbstract ? "A" : " ";
        str += this.symmetric ? "S" : " ";
        str += " " + this.browseName.toString() + "/" + this.inverseName.text + " ";
        str += this.nodeId.toString();
        return str;
    }
    install_extra_properties() {
        /**  */
    }
    /**
     * returns a array of all ReferenceTypes in the addressSpace that are self or a subType of self
     * recursively
     */
    getAllSubtypes() {
        return _getAllSubtypes(this);
    }
    checkHasSubtype(ref) {
        const _index = _getSubtypeIndex(this);
        const referenceTypeNodeId = ref instanceof reference_impl_1.ReferenceImpl ? ref.nodeId : ref;
        const _key = referenceTypeNodeId.toString();
        return _index.has(_key);
    }
}
exports.UAReferenceTypeImpl = UAReferenceTypeImpl;
//# sourceMappingURL=ua_reference_type_impl.js.map