/**
 * @module node-opcua-address-space
 */
import { UAReference, UAReferenceType } from "node-opcua-address-space-base";
import { LocalizedTextOptions } from "node-opcua-data-model";
import { LocalizedText, NodeClass } from "node-opcua-data-model";
import { AttributeIds } from "node-opcua-data-model";
import { DataValue } from "node-opcua-data-value";
import { NodeId } from "node-opcua-nodeid";
import { SessionContext, UAReferenceType as UAReferenceTypePublic } from "../source";
import { BaseNodeImpl, InternalBaseNodeOptions } from "./base_node_impl";
export interface UAReferenceTypeOptions extends InternalBaseNodeOptions {
    isAbstract?: boolean;
    symmetric?: boolean;
    inverseName: null | string | LocalizedTextOptions;
}
export declare class UAReferenceTypeImpl extends BaseNodeImpl implements UAReferenceType {
    readonly nodeClass = NodeClass.ReferenceType;
    readonly isAbstract: boolean;
    readonly symmetric: boolean;
    readonly inverseName: LocalizedText;
    get subtypeOfObj(): UAReferenceTypePublic | null;
    get subtypeOf(): NodeId | null;
    /**
     * returns true if self is  a super type of baseType
     */
    isSubtypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UAReferenceType>;
    /** @deprecated - use `isSubtypeOf` instead*/
    isSupertypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UAReferenceType>;
    /**
     * @private
     */
    _slow_isSubtypeOf: (this: UAReferenceType, baseType: import("node-opcua-nodeid").NodeIdLike | UAReferenceType) => boolean;
    constructor(options: UAReferenceTypeOptions);
    readAttribute(context: SessionContext | null, attributeId: AttributeIds): DataValue;
    toString(): string;
    install_extra_properties(): void;
    /**
     * returns a array of all ReferenceTypes in the addressSpace that are self or a subType of self
     * recursively
     */
    getAllSubtypes(): UAReferenceType[];
    checkHasSubtype(ref: UAReference | NodeId): boolean;
}
