"use strict";
/**
 * @module node-opcua-address-space
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.wipeMemorizedStuff = wipeMemorizedStuff;
exports.construct_isSubtypeOf = construct_isSubtypeOf;
exports.construct_slow_isSubtypeOf = construct_slow_isSubtypeOf;
exports.get_subtypeOf = get_subtypeOf;
exports.get_subtypeOfObj = get_subtypeOfObj;
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_nodeid_2 = require("node-opcua-nodeid");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const base_node_private_1 = require("./base_node_private");
const reference_impl_1 = require("./reference_impl");
const HasSubTypeNodeId = (0, node_opcua_nodeid_1.resolveNodeId)("HasSubtype");
function _filterSubType(reference) {
    return (0, node_opcua_nodeid_2.sameNodeId)(reference.referenceType, HasSubTypeNodeId) && !reference.isForward;
}
function _slow_isSubtypeOf(Class, baseType) {
    if (!(baseType instanceof Class)) {
        const node = this.addressSpace.findNode(baseType);
        if (!node || !(node instanceof Class)) {
            throw new Error("Invalid argument");
        }
        return _slow_isSubtypeOf.call(this, Class, node);
    }
    (0, node_opcua_assert_1.assert)(this instanceof Class);
    (0, node_opcua_assert_1.assert)(baseType instanceof Class, " Object must have same type");
    (0, node_opcua_assert_1.assert)(this.addressSpace);
    if ((0, node_opcua_nodeid_2.sameNodeId)(this.nodeId, baseType.nodeId)) {
        return true;
    }
    const references = this.allReferences();
    const subTypes = references.filter(_filterSubType);
    (0, node_opcua_assert_1.assert)(subTypes.length <= 1, "should have zero or one subtype no more");
    for (const subType1 of subTypes) {
        const subTypeId = subType1.nodeId;
        const subTypeNode = this.addressSpace.findNode(subTypeId);
        // istanbul ignore next
        if (!subTypeNode) {
            throw new Error("Cannot find object with nodeId " + subTypeId.toString());
        }
        if ((0, node_opcua_nodeid_2.sameNodeId)(subTypeNode.nodeId, baseType.nodeId)) {
            return true;
        }
        else {
            if (_slow_isSubtypeOf.call(subTypeNode, Class, baseType)) {
                return true;
            }
        }
    }
    return false;
}
const g_WeakMap = new WeakMap();
function wipeMemorizedStuff(node) {
    if (g_WeakMap.has(node)) {
        g_WeakMap.delete(node);
    }
}
//  http://jsperf.com/underscore-js-memoize-refactor-test
//  http://addyosmani.com/blog/faster-javascript-memoization/
function wrap_memoize(func, hashFunc) {
    if (undefined === hashFunc) {
        hashFunc = (_p) => _p.toString();
    }
    return function memoize(param) {
        const self = this;
        if (!g_WeakMap.has(self)) {
            g_WeakMap.set(self, new Map());
        }
        const memoMap = g_WeakMap.get(self);
        const hash = hashFunc.call(this, param);
        if (memoMap.has(hash)) {
            return memoMap.get(hash);
        }
        const cache_value = func.call(this, param);
        memoMap.set(hash, cache_value);
        return cache_value;
    };
}
function hashBaseNode(e) {
    return e.nodeId.toString();
}
function construct_isSubtypeOf(Class) {
    return wrap_memoize(function (baseType) {
        if (!(baseType instanceof Class)) {
            throw new Error("expecting baseType to be " +
                Class.name +
                " but got " +
                baseType.toString() +
                " " +
                node_opcua_data_model_1.NodeClass[baseType.nodeClass]);
        }
        if (!(this instanceof Class)) {
            throw new Error("expecting this to be " + Class.name + " but got " + baseType.toString());
        }
        return _slow_isSubtypeOf.call(this, Class, baseType);
    }, hashBaseNode);
}
function construct_slow_isSubtypeOf(Class) {
    return function (baseType) {
        return _slow_isSubtypeOf.call(this, Class, baseType);
    };
}
/**
 * returns the nodeId of the Type which is the super type of this
 */
function get_subtypeOf() {
    const s = get_subtypeOfObj.call(this);
    return s ? s.nodeId : null;
}
function get_subtypeOfObj() {
    const _cache = (0, base_node_private_1.BaseNode_getCache)(this);
    if (_cache._subtypeOfObj == undefined) {
        const is_subtype_of_ref = this.findReference("HasSubtype", false);
        if (is_subtype_of_ref) {
            _cache._subtypeOfObj = reference_impl_1.ReferenceImpl.resolveReferenceNode(this.addressSpace, is_subtype_of_ref);
        }
        else {
            _cache._subtypeOfObj = null;
        }
    }
    return _cache._subtypeOfObj;
}
//# sourceMappingURL=tool_isSubtypeOf.js.map