/**
 * @module node-opcua-address-space
 */
import { NodeId, NodeIdLike } from "node-opcua-nodeid";
import { BaseNode, UADataType, UAObjectType, UAReferenceType, UAVariableType } from "node-opcua-address-space-base";
import { BaseNodeImpl } from "./base_node_impl";
export type BaseNodeConstructor<T extends BaseNode> = new () => T;
export type MemberFuncValue<T, P, R> = (this: T, param: P) => R;
export declare function wipeMemorizedStuff(node: Object): void;
export type IsSubtypeOfFunc<T extends UAType> = (this: T, baseType: T) => boolean;
export type UAType = UAReferenceType | UADataType | UAObjectType | UAVariableType;
export declare function construct_isSubtypeOf<T extends UAType>(Class: typeof BaseNodeImpl): IsSubtypeOfFunc<T>;
export declare function construct_slow_isSubtypeOf<T extends UAType>(Class: typeof BaseNodeImpl): (this: T, baseType: T | NodeIdLike) => boolean;
/**
 * returns the nodeId of the Type which is the super type of this
 */
export declare function get_subtypeOf<T extends BaseNode>(this: T): NodeId | null;
export declare function get_subtypeOfObj(this: BaseNode): BaseNode | null;
