"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports._getBasicDataTypeFromDataTypeNodeId = _getBasicDataTypeFromDataTypeNodeId;
exports._getBasicDataType = _getBasicDataType;
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
function _getBasicDataTypeFromDataTypeNodeId(addressSpace, dataTypeNodeId) {
    const dataTypeNodeId_ = dataTypeNodeId.nodeId ? dataTypeNodeId.nodeId : dataTypeNodeId;
    const dataTypeNode = addressSpace.findDataType(dataTypeNodeId_);
    if (!dataTypeNode) {
        return node_opcua_basic_types_1.DataType.Null;
    }
    return dataTypeNode.getBasicDataType();
}
function _getBasicDataType(uaNode) {
    const _uaNode = uaNode;
    if (_uaNode._basicDataType) {
        return _uaNode._basicDataType;
    }
    if (_uaNode.dataType.namespace === 0 && _uaNode.dataType.value === 0) {
        return node_opcua_basic_types_1.DataType.Null;
    }
    const addressSpace = _uaNode.addressSpace;
    if (!addressSpace) {
        // may be node has been deleted already
        return node_opcua_basic_types_1.DataType.Null;
    }
    _uaNode._basicDataType = _getBasicDataTypeFromDataTypeNodeId(addressSpace, _uaNode.dataType);
    return _uaNode._basicDataType;
}
//# sourceMappingURL=get_basic_datatype.js.map