"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.adjustDataValueStatusCode = adjustDataValueStatusCode;
/**
 * @module node-opcua-address-space.DataAccess
 */
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_data_model_1 = require("node-opcua-data-model");
function validate_value_range(range, variant) {
    if (variant.value < range.low || variant.value > range.high) {
        return false;
    }
    return true;
}
function adjustDataValueStatusCode(variable, dataValue, acceptValueOutOfRange) {
    const instrumentRange = variable.getChildByName("InstrumentRange");
    if (instrumentRange && instrumentRange.nodeClass === node_opcua_data_model_1.NodeClass.Variable) {
        if (!validate_value_range(instrumentRange.readValue().value.value, dataValue.value)) {
            if (!acceptValueOutOfRange) {
                return node_opcua_status_code_1.StatusCodes.BadOutOfRange;
            }
            else {
                dataValue.statusCode = node_opcua_status_code_1.StatusCodes.BadOutOfRange;
            }
        }
    }
    return node_opcua_status_code_1.StatusCodes.Good;
}
//# sourceMappingURL=adjust_datavalue_status_code.js.map