"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToStringBuilder = void 0;
exports.BaseNode_initPrivate = BaseNode_initPrivate;
exports.BaseNode_removePrivate = BaseNode_removePrivate;
exports.BaseNode_getPrivate = BaseNode_getPrivate;
exports.BaseNode_getCache = BaseNode_getCache;
exports.BaseNode_clearCache = BaseNode_clearCache;
exports.BaseNode_toString = BaseNode_toString;
exports.BaseNode_References_toString = BaseNode_References_toString;
exports.UAVariableType_toString = UAVariableType_toString;
exports.UAVariable_toString = UAVariable_toString;
exports.UAObject_toString = UAObject_toString;
exports.UAObjectType_toString = UAObjectType_toString;
exports.valueRankToString = valueRankToString;
exports.VariableOrVariableType_toString = VariableOrVariableType_toString;
exports._clone_hierarchical_references = _clone_hierarchical_references;
exports._clone_non_hierarchical_references = _clone_non_hierarchical_references;
exports._clone = _clone;
exports._handle_HierarchicalReference = _handle_HierarchicalReference;
exports._get_HierarchicalReference = _get_HierarchicalReference;
exports._remove_HierarchicalReference = _remove_HierarchicalReference;
exports._constructReferenceDescription = _constructReferenceDescription;
exports.BaseNode_remove_backward_reference = BaseNode_remove_backward_reference;
exports.BaseNode_add_backward_reference = BaseNode_add_backward_reference;
/* eslint-disable complexity */
/* eslint-disable max-statements */
/**
 * @module node-opcua-address-space.Private
 */
// tslint:disable:no-bitwise
const chalk_1 = __importDefault(require("chalk"));
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_types_1 = require("node-opcua-types");
const node_opcua_address_space_base_1 = require("node-opcua-address-space-base");
const node_opcua_constants_1 = require("node-opcua-constants");
const namespace_private_1 = require("./namespace_private");
const reference_impl_1 = require("./reference_impl");
const base_node_impl_1 = require("./base_node_impl");
const tool_isSubtypeOf_1 = require("./tool_isSubtypeOf");
// eslint-disable-next-line prefer-const
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
const doTrace = (0, node_opcua_debug_1.checkDebugFlag)("INSTANTIATE");
const traceLog = errorLog;
const g_weakMap = new WeakMap();
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
function BaseNode_initPrivate(self) {
    const _private = {
        __address_space: null,
        _referenceIdx: new Map(),
        _back_referenceIdx: new Map(),
        _browseFilter: undefined,
        _cache: {},
        _description: undefined,
        _displayName: [],
        _parent: undefined,
    };
    g_weakMap.set(self, _private);
    return _private;
}
function BaseNode_removePrivate(self) {
    // there is no need to delete object from weak map
    // the GC will take care of this in due course
    // g_weakMap.delete(self);
    const _private = BaseNode_getPrivate(self);
    _private._cache = {};
    _private.__address_space = null;
    _private._back_referenceIdx = new Map();
    _private._referenceIdx = new Map();
    _private._description = undefined;
    _private._displayName = [];
}
function BaseNode_getPrivate(self) {
    return g_weakMap.get(self);
}
function BaseNode_getCache(node) {
    return BaseNode_getPrivate(node)._cache;
}
function BaseNode_clearCache(node) {
    const _private = BaseNode_getPrivate(node);
    if (_private && _private._cache) {
        _private._cache = {};
    }
    (0, tool_isSubtypeOf_1.wipeMemorizedStuff)(node);
}
const hasTypeDefinition_ReferenceTypeNodeId = (0, node_opcua_nodeid_1.resolveNodeId)("HasTypeDefinition");
class ToStringBuilder {
    level = 0;
    cycleDetector = {};
    padding = "";
    str = [];
    constructor() {
        //
        this.str = [];
    }
    add(line) {
        this.str.push(line);
    }
    toString() {
        return this.str.join("\n");
    }
    indent(str, padding) {
        padding = padding || "          ";
        return str
            .split("\n")
            .map((r) => {
            return padding + r;
        })
            .join("\n");
    }
}
exports.ToStringBuilder = ToStringBuilder;
function set_as_processed(options, nodeId) {
    options.cycleDetector[nodeId.toString()] = nodeId;
}
function is_already_processed(options, nodeId) {
    return !!options.cycleDetector[nodeId.toString()];
}
function BaseNode_toString(options) {
    options.level = options.level || 1;
    set_as_processed(options, this.nodeId);
    options.add("");
    options.add(options.padding + chalk_1.default.yellow("          nodeId              : ") + this.nodeId.toString());
    options.add(options.padding + chalk_1.default.yellow("          nodeClass           : ") + node_opcua_data_model_1.NodeClass[this.nodeClass] + " (" + this.nodeClass + ")");
    options.add(options.padding + chalk_1.default.yellow("          browseName          : ") + this.browseName.toString());
    options.add(options.padding +
        chalk_1.default.yellow("          displayName         : ") +
        this.displayName.map((f) => f.locale + " " + f.text).join(" | "));
    options.add(options.padding + chalk_1.default.yellow("          description         : ") + (this.description ? this.description.toString() : ""));
}
function BaseNode_References_toString(options) {
    const _private = BaseNode_getPrivate(this);
    const displayOptions = {
        addressSpace: this.addressSpace
    };
    const addressSpace = this.addressSpace;
    options.add(options.padding +
        chalk_1.default.yellow("    references                : ") +
        "  length =" +
        _private._referenceIdx.size);
    function dump_reference(follow, reference) {
        if (!reference) {
            return;
        }
        const o = reference_impl_1.ReferenceImpl.resolveReferenceNode(addressSpace, reference);
        if (!o) {
            warningLog("cannot find reference", reference.toString());
            return;
        }
        const name = o.browseName.toString();
        const modellingRule = o.modellingRule || " ";
        const extra = modellingRule[0] +
            (() => {
                switch (o.nodeClass) {
                    case node_opcua_data_model_1.NodeClass.Object:
                        return "[O] ";
                    case node_opcua_data_model_1.NodeClass.Variable:
                        return "[V] " + o.dataType.toString(displayOptions).padEnd(10);
                    case node_opcua_data_model_1.NodeClass.Method:
                        return "[M] ";
                    case node_opcua_data_model_1.NodeClass.DataType:
                        return "[DT]";
                    case node_opcua_data_model_1.NodeClass.ReferenceType:
                        return "[RT]";
                    case node_opcua_data_model_1.NodeClass.ObjectType:
                        return "[OT]";
                    case node_opcua_data_model_1.NodeClass.VariableType:
                        return "[VT]";
                    case node_opcua_data_model_1.NodeClass.View:
                        return "[V] ";
                }
                return "";
            })();
        options.add(options.padding +
            chalk_1.default.yellow("      +-> ") +
            reference.toString(displayOptions) +
            " " +
            chalk_1.default.cyan(name.padEnd(25, " ")) +
            " " +
            chalk_1.default.magentaBright(extra));
        // ignore HasTypeDefinition as it has been already handled
        if ((0, node_opcua_nodeid_1.sameNodeId)(reference.referenceType, hasTypeDefinition_ReferenceTypeNodeId) && reference.nodeId.namespace === 0) {
            return;
        }
        if (o) {
            if (!is_already_processed(options, o.nodeId)) {
                set_as_processed(options, o.nodeId);
                if (options.level > 1 && follow) {
                    const rr = o.toString({
                        cycleDetector: options.cycleDetector,
                        level: options.level - 1,
                        padding: options.padding + "         "
                    });
                    options.add(rr);
                }
            }
        }
    }
    // direct reference
    for (var r of _private._referenceIdx.values()) {
        dump_reference(false, r);
    }
    options.add(options.padding +
        chalk_1.default.yellow("    back_references                 : ") +
        chalk_1.default.cyan("  length =") +
        _private._back_referenceIdx.size +
        chalk_1.default.grey(" ( references held by other nodes involving this node)"));
    for (const r of _private._back_referenceIdx.values()) {
        dump_reference(false, r);
    }
    // backward reference
}
function _UAType_toString(options) {
    if (this.subtypeOfObj) {
        options.add(options.padding +
            chalk_1.default.yellow("          subtypeOf           : ") +
            this.subtypeOfObj.browseName.toString() +
            " (" +
            this.subtypeOfObj.nodeId.toString() +
            ")");
    }
}
function _UAInstance_toString(options) {
    if (this.typeDefinitionObj) {
        options.add(options.padding +
            chalk_1.default.yellow("          typeDefinition      : ") +
            this.typeDefinitionObj.browseName.toString() +
            " (" +
            this.typeDefinitionObj.nodeId.toString() +
            ")");
    }
}
function UAVariableType_toString(options) {
    BaseNode_toString.call(this, options);
    _UAType_toString.call(this, options);
    VariableOrVariableType_toString.call(this, options);
    BaseNode_References_toString.call(this, options);
}
function UAVariable_toString(options) {
    BaseNode_toString.call(this, options);
    _UAInstance_toString.call(this, options);
    VariableOrVariableType_toString.call(this, options);
    AccessLevelFlags_toString.call(this, options);
    BaseNode_References_toString.call(this, options);
}
function UAObject_toString(options) {
    BaseNode_toString.call(this, options);
    _UAInstance_toString.call(this, options);
    BaseNode_References_toString.call(this, options);
}
function UAObjectType_toString(options) {
    BaseNode_toString.call(this, options);
    _UAType_toString.call(this, options);
    BaseNode_References_toString.call(this, options);
}
function valueRankToString(valueRank) {
    switch (valueRank) {
        case 1:
            return "OneDimension (1)";
        case 0:
            return "OneOrMoreDimensions (0)"; // The value is an array with one or more dimensions
        case -1:
            return "Scalar (-1)";
        case -2:
            return "Any (-2)"; // The value can be a scalar or an array with any number of dimensions
        case -3:
            return "ScalarOrOneDimension (2)"; // The value can be a scalar or a one dimensional array.
        default:
            if (valueRank > 0) {
                return "" + valueRank + "-Dimensions";
            }
            else {
                return "Invalid (" + valueRank + ")";
            }
    }
}
function accessLevelFlagToString(flag) {
    const str = [];
    if (flag & node_opcua_data_model_1.AccessLevelFlag.CurrentRead) {
        str.push("CurrentRead");
    }
    if (flag & node_opcua_data_model_1.AccessLevelFlag.CurrentWrite) {
        str.push("CurrentWrite");
    }
    if (flag & node_opcua_data_model_1.AccessLevelFlag.HistoryRead) {
        str.push("HistoryRead");
    }
    if (flag & node_opcua_data_model_1.AccessLevelFlag.HistoryWrite) {
        str.push("HistoryWrite");
    }
    if (flag & node_opcua_data_model_1.AccessLevelFlag.SemanticChange) {
        str.push("SemanticChange");
    }
    if (flag & node_opcua_data_model_1.AccessLevelFlag.StatusWrite) {
        str.push("StatusWrite");
    }
    if (flag & node_opcua_data_model_1.AccessLevelFlag.TimestampWrite) {
        str.push("TimestampWrite");
    }
    return str.join(" | ");
}
function AccessLevelFlags_toString(options) {
    (0, node_opcua_assert_1.assert)(options);
    options.add(options.padding + chalk_1.default.yellow("          accessLevel         : ") + " " + accessLevelFlagToString(this.accessLevel));
    if (this.userAccessLevel !== undefined) {
        options.add(options.padding + chalk_1.default.yellow("          userAccessLevel     : ") + " " + accessLevelFlagToString(this.userAccessLevel));
    }
}
function VariableOrVariableType_toString(options) {
    (0, node_opcua_assert_1.assert)(options);
    if (this.dataType) {
        const addressSpace = this.addressSpace;
        const d = addressSpace.findNode(this.dataType);
        const n = d ? "(" + d.browseName.toString() + ")" : " (???)";
        options.add(options.padding + chalk_1.default.yellow("          dataType            : ") + this.dataType + "  " + n);
    }
    if (this.nodeClass === node_opcua_data_model_1.NodeClass.Variable) {
        const _dataValue = this.$dataValue;
        if (_dataValue) {
            options.add(options.padding +
                chalk_1.default.yellow("          value               : ") +
                "\n" +
                options.indent(_dataValue.toString(), options.padding + "                        | "));
        }
    }
    if (Object.prototype.hasOwnProperty.call(this, "valueRank")) {
        if (this.valueRank !== undefined) {
            options.add(options.padding + chalk_1.default.yellow("          valueRank           : ") + " " + valueRankToString(this.valueRank));
        }
        else {
            options.add(options.padding + chalk_1.default.yellow("          valueRank           : ") + " undefined");
        }
    }
    if (this.minimumSamplingInterval !== undefined) {
        options.add(options.padding +
            chalk_1.default.yellow(" minimumSamplingInterval      : ") +
            " " +
            this.minimumSamplingInterval.toString() +
            " ms");
    }
    if (this.arrayDimensions) {
        options.add(options.padding +
            chalk_1.default.yellow(" arrayDimension               : ") +
            " [" +
            this.arrayDimensions.join(",").toString() +
            " ]");
    }
}
/**
 *
 *
 *    MyDeriveType  ------------------- -> MyBaseType    --------------> TopologyElementType
 *        |                                   |                                   |
 *        +- ParameterSet                     +-> ParameterSet                    +-> ParameterSet
 *                 |                                   |
 *                  +- Foo1                            |
 *                                                     +- Bar
 *
 *    Instance
 *
 * @param newParent
 * @param node
 * @param copyAlsoModellingRules
 * @param optionalFilter
 * @param extraInfo
 * @param browseNameMap
 * @returns
 */
function _clone_children_on_template(nodeToClone, newParent, node, copyAlsoModellingRules, optionalFilter, extraInfo) {
    /**
     * the type definition node of the node to clone
     */
    const nodeToCloneTypeDefinition = nodeToClone.nodeClass === node_opcua_data_model_1.NodeClass.ObjectType || nodeToClone.nodeClass === node_opcua_data_model_1.NodeClass.VariableType
        ? nodeToClone.subtypeOfObj
        : null;
    if (!nodeToCloneTypeDefinition)
        return;
    // istanbul ignore next
    doTrace &&
        traceLog(extraInfo?.pad(), chalk_1.default.gray("-------------------- now cloning children on template ", node.browseName.toString(), node.nodeId.toString(), nodeToCloneTypeDefinition.browseName.toString()));
    const namespace = newParent.namespace;
    /**
     * the child node of the new parent that match the node to clone or enrich
     */
    const newParentChild = newParent.getChildByName(node.browseName);
    if (!newParentChild) {
        return;
    }
    // we have found a matching child on the new parent.
    // the mission is to enrich this child node with components and properties that
    // exist also in the template
    let typeDefinitionNode = nodeToCloneTypeDefinition;
    while (typeDefinitionNode) {
        // istanbul ignore next
        doTrace &&
            traceLog(extraInfo?.pad(), chalk_1.default.green("-------------------- now cloning children on ", newParentChild.browseName.toString(), newParentChild.nodeId.toString(), " (child of ", node.browseName.toString(), node.nodeId.toString(), ") from ", typeDefinitionNode.browseName.toString()));
        // Find aggregates with same browseName as node. Do not search children as this includes nodes with HasSubType relation which we do
        // not want. See issue #1326.
        const aggregates = typeDefinitionNode.getAggregates().filter((n) => n.browseName.equals(node.browseName));
        const typeDefinitionChild = aggregates.length > 0 ? aggregates[0] : null;
        if (typeDefinitionChild) {
            const references = typeDefinitionChild.findReferencesEx("Aggregates", node_opcua_data_model_1.BrowseDirection.Forward);
            for (const ref of references) {
                const grandChild = ref.node;
                if (grandChild.modellingRule === "MandatoryPlaceholder" || grandChild.modellingRule === "OptionalPlaceholder")
                    continue;
                // if not already node present in new Parent => just ignore
                const hasAlready = newParentChild.getChildByName(grandChild.browseName) !== null;
                if (!hasAlready) {
                    if (optionalFilter && node && !optionalFilter.shouldKeep(node)) {
                        // istanbul ignore next
                        doTrace &&
                            traceLog(extraInfo.pad(), "skipping optional ", node.browseName.toString(), "that doesn't appear in the filter");
                        continue; // skip this node
                    }
                    const options = {
                        namespace,
                        references: [
                            new reference_impl_1.ReferenceImpl({
                                referenceType: ref.referenceType,
                                isForward: false,
                                nodeId: newParentChild.nodeId
                            })
                        ],
                        copyAlsoModellingRules
                    };
                    const alreadyCloned = extraInfo.getCloned({
                        originalParent: nodeToClone,
                        clonedParent: newParent,
                        originalNode: grandChild
                    });
                    if (alreadyCloned) {
                        alreadyCloned.addReference({
                            referenceType: ref.referenceType,
                            isForward: false,
                            nodeId: newParentChild.nodeId
                        });
                    }
                    else {
                        const clonedGrandChild = grandChild.clone(options, optionalFilter, extraInfo);
                        extraInfo.registerClonedObject({
                            originalNode: grandChild,
                            clonedNode: clonedGrandChild
                        });
                    }
                }
            }
        }
        typeDefinitionNode = typeDefinitionNode.subtypeOfObj;
    }
}
/*
 * clone properties and methods
 * @private
 */
function _clone_collection_new(nodeToClone, newParent, collectionRef, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap) {
    const namespace = newParent.namespace;
    extraInfo = extraInfo || new node_opcua_address_space_base_1.CloneHelper();
    const addressSpace = newParent.addressSpace;
    (0, node_opcua_assert_1.assert)(!optionalFilter || (typeof optionalFilter.shouldKeep === "function" && typeof optionalFilter.filterFor === "function"));
    for (const reference of collectionRef) {
        const node = reference_impl_1.ReferenceImpl.resolveReferenceNode(addressSpace, reference);
        // ensure node is of the correct type,
        // it may happen that the xml nodeset2 file was malformed
        // istanbul ignore next
        if (typeof node.clone !== "function") {
            // tslint:disable-next-line:no-console
            warningLog(chalk_1.default.red("Warning : cannot clone node ") +
                (0, node_opcua_address_space_base_1.fullPath2)(node) +
                " of class " +
                node_opcua_data_model_1.NodeClass[node.nodeClass].toString() +
                " while cloning " +
                (0, node_opcua_address_space_base_1.fullPath2)(newParent));
            continue;
        }
        if (node && !node.modellingRule) {
            // istanbul ignore next
            doTrace && traceLog(extraInfo.pad(), "skipping  with no modelling rule", (0, node_opcua_address_space_base_1.fullPath2)(node));
            // those node stays in the Type
            continue; // skip this node
        }
        if (optionalFilter && node && !optionalFilter.shouldKeep(node)) {
            // istanbul ignore next
            doTrace && traceLog(extraInfo.pad(), "skipping optional that doesn't appear in the filter", (0, node_opcua_address_space_base_1.fullPath2)(node));
            continue; // skip this node
        }
        const key = newParent.nodeId.toString() + "(" + newParent.browseName.toString() + ")" + "/" + node.browseName.toString();
        if (browseNameMap?.has(key)) {
            _clone_children_on_template(nodeToClone, newParent, node, copyAlsoModellingRules, optionalFilter, extraInfo);
            doTrace &&
                traceLog(extraInfo.pad(), "skipping required node with same browseName", (0, node_opcua_address_space_base_1.fullPath2)(node), "because it has already been cloned", "key=", key);
            continue; // skipping node with same browseName
        }
        browseNameMap?.add(key);
        // assert(reference.isForward);
        // assert(reference.referenceType instanceof NodeId, "" + reference.referenceType.toString());
        const options = {
            namespace,
            references: [new reference_impl_1.ReferenceImpl({ referenceType: reference.referenceType, isForward: false, nodeId: newParent.nodeId })],
            copyAlsoModellingRules
        };
        const alreadyCloned = extraInfo.getCloned({ originalParent: nodeToClone, clonedParent: newParent, originalNode: node });
        if (alreadyCloned) {
            // istanbul ignore next
            doTrace &&
                traceLog(extraInfo.pad(), "node ", (0, node_opcua_address_space_base_1.fullPath2)(node), "already cloned as", (0, node_opcua_address_space_base_1.fullPath2)(alreadyCloned), "\nnode to clone =", (0, node_opcua_address_space_base_1.fullPath2)(nodeToClone), "\nnew parent   =", (0, node_opcua_address_space_base_1.fullPath2)(newParent));
            const hasReference = alreadyCloned.findReferencesExAsObject(reference.referenceType, node_opcua_data_model_1.BrowseDirection.Inverse).length > 0;
            if (!hasReference) {
                alreadyCloned.addReference({
                    referenceType: reference.referenceType,
                    isForward: false,
                    nodeId: newParent.nodeId
                });
            }
            else {
                // istanbul ignore next
                doTrace && traceLog(extraInfo.pad(), "reference to node  ", (0, node_opcua_address_space_base_1.fullPath2)(alreadyCloned), " already exists !");
            }
        }
        else {
            // istanbul ignore next
            doTrace &&
                traceLog(extraInfo.pad(), "cloning => ", reference.referenceType.toString({ addressSpace }), "=>", (0, node_opcua_address_space_base_1.fullPath2)(node), chalk_1.default.magentaBright(node.typeDefinitionObj?.browseName.toString()));
            extraInfo.level += 1;
            const clonedNode = node.clone(options, optionalFilter, extraInfo);
            extraInfo.level -= 1;
            // istanbul ignore next
            doTrace &&
                traceLog(extraInfo.pad(), "cloned => ", (0, node_opcua_address_space_base_1.fullPath2)(node), "", extraInfo.pad(), "    original nodeId", node.nodeId.toString(), "", extraInfo.pad(), "    cloned   nodeId", clonedNode.nodeId.toString(), (0, node_opcua_address_space_base_1.fullPath2)(clonedNode) + "");
            extraInfo.level++;
            _clone_children_on_template(nodeToClone, newParent, node, copyAlsoModellingRules, optionalFilter, extraInfo);
            extraInfo.level--;
            // also clone or instantiate interface members that may be required in the optionals
            extraInfo.level++;
            _cloneInterface(nodeToClone, newParent, node, optionalFilter, extraInfo, browseNameMap);
            extraInfo.level--;
            // === clone);
            // extraInfo.registerClonedObject(clone, node);
        }
    }
}
function _extractInterfaces2(typeDefinitionNode, extraInfo) {
    if (!typeDefinitionNode ||
        (typeDefinitionNode.nodeId.namespace === 0 &&
            (typeDefinitionNode.nodeId.value === node_opcua_constants_1.ObjectTypeIds.BaseObjectType ||
                typeDefinitionNode.nodeId.value === node_opcua_constants_1.VariableTypeIds.BaseVariableType))) {
        return [];
    }
    const addressSpace = typeDefinitionNode.addressSpace;
    const hasInterfaceReference = addressSpace.findReferenceType("HasInterface");
    if (!hasInterfaceReference) {
        // this version of the standard UA namespace doesn't support Interface yet
        return [];
    }
    // example:
    // FolderType
    //   FunctionalGroupType
    //     MachineryItemIdentificationType     : IMachineryItemVendorNameplateType
    //       MachineIdentificationType         : IMachineTagNameplateType, IMachineVendorNamePlateType
    //         MachineToolIdentificationType
    //
    //
    // IMachineTagNameplateType            -subtypeOf-> ITagNameplateType
    // IMachineVendorNamePlateType         -subtypeOf-> IMachineryItemVendorNamePlateType
    // IMachineryItemVendorNamePlateType   -subtypeOf-> IVendorNameplateType
    const interfacesRef = typeDefinitionNode.findReferencesEx("HasInterface", node_opcua_data_model_1.BrowseDirection.Forward);
    const interfaces = interfacesRef.map((r) => addressSpace.findNode(r.nodeId));
    const baseInterfaces = [];
    for (const iface of interfaces) {
        // istanbul ignore next
        doTrace &&
            traceLog(extraInfo.pad(), typeDefinitionNode.browseName.toString(), " - has interface -> ", iface.browseName.toString());
        baseInterfaces.push(iface);
        if (iface.subtypeOfObj) {
            extraInfo.level++;
            baseInterfaces.push(..._extractInterfaces2(iface.subtypeOfObj, extraInfo));
            extraInfo.level--;
        }
    }
    interfaces.push(...baseInterfaces);
    if (typeDefinitionNode.subtypeOfObj) {
        // istanbul ignore next
        doTrace &&
            traceLog(extraInfo.pad(), typeDefinitionNode.browseName.toString(), " - subtypeOf  -> ", typeDefinitionNode.subtypeOfObj.browseName.toString());
        extraInfo.level++;
        interfaces.push(..._extractInterfaces2(typeDefinitionNode.subtypeOfObj, extraInfo));
        extraInfo.level--;
    }
    const deduplicatedInterfaces = [...new Set(interfaces)];
    // istanbul ignore next
    doTrace &&
        deduplicatedInterfaces.length &&
        traceLog(extraInfo.pad(), chalk_1.default.yellow("Interface for ", typeDefinitionNode.browseName.toString()), "=", deduplicatedInterfaces.map((x) => x.browseName.toString()).join(" "));
    return deduplicatedInterfaces;
}
function _cloneInterface(nodeToClone, newParent, node, optionalFilter, extraInfo, browseNameMap) {
    // istanbul ignore next
    doTrace &&
        traceLog(extraInfo?.pad(), chalk_1.default.green("-------------------- now cloning interfaces of ", node.browseName.toString(), node.nodeId.toString()));
    extraInfo = extraInfo || new node_opcua_address_space_base_1.CloneHelper();
    const addressSpace = node.addressSpace;
    if (node.nodeClass !== node_opcua_data_model_1.NodeClass.Object && node.nodeClass !== node_opcua_data_model_1.NodeClass.Variable) {
        return;
    }
    const typeDefinitionNode = node.typeDefinitionObj;
    if (!typeDefinitionNode) {
        return;
    }
    const interfaces = _extractInterfaces2(typeDefinitionNode, extraInfo);
    if (interfaces.length === 0) {
        // istanbul ignore next
        doTrace &&
            false &&
            traceLog(extraInfo.pad(), chalk_1.default.yellow("No interface for ", node.browseName.toString(), node.nodeId.toString()));
        return;
    }
    // istanbul ignore next
    doTrace && traceLog(extraInfo?.pad(), chalk_1.default.green("-------------------- interfaces are  ", interfaces.length));
    const localFilter = optionalFilter.filterFor(node);
    for (const iface of interfaces) {
        const aggregates = iface.findReferencesEx("Aggregates", node_opcua_data_model_1.BrowseDirection.Forward);
        if (aggregates.length === 0)
            continue;
        // istanbul ignore next
        doTrace &&
            traceLog(extraInfo.pad(), chalk_1.default.magentaBright("   interface ", iface.browseName.toString()), "\n" + extraInfo?.pad(), aggregates.map((r) => r.toString({ addressSpace })).join("\n" + extraInfo?.pad()));
        _clone_collection_new(nodeToClone, node, aggregates, false, localFilter, extraInfo, browseNameMap);
    }
}
function __clone_organizes_references(nodeToClone, newParent, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap) {
    // find all references that derives from the Organizes
    const organizedRef = nodeToClone.findReferencesEx("Organizes", node_opcua_data_model_1.BrowseDirection.Forward);
    if (organizedRef.length === 0)
        return;
    _clone_collection_new(nodeToClone, newParent, organizedRef, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap);
}
function __clone_children_references(nodeToClone, newParent, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap) {
    // find all references that derives from the Aggregates
    const aggregatesRef = nodeToClone.findReferencesEx("Aggregates", node_opcua_data_model_1.BrowseDirection.Forward);
    if (aggregatesRef.length === 0)
        return;
    _clone_collection_new(nodeToClone, newParent, aggregatesRef, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap);
}
function _clone_hierarchical_references(nodeToClone, newParent, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap) {
    __clone_children_references(nodeToClone, newParent, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap);
    __clone_organizes_references(nodeToClone, newParent, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap);
}
function _clone_non_hierarchical_references(nodeToClone, newParent, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap) {
    // clone only some non hierarchical_references that we do want to clone
    // such as:
    //   HasSubStateMachine
    //   (may be other as well later ... to do )
    (0, node_opcua_assert_1.assert)(newParent instanceof base_node_impl_1.BaseNodeImpl);
    // find all reference that derives from the HasSubStateMachine
    const references = nodeToClone.findReferencesEx("HasSubStateMachine", node_opcua_data_model_1.BrowseDirection.Forward);
    if (references.length === 0)
        return;
    _clone_collection_new(nodeToClone, newParent, references, copyAlsoModellingRules, optionalFilter, extraInfo, browseNameMap);
}
/**

 * @private
 */
function _clone(originalNode, Constructor, options, optionalFilter, extraInfo) {
    (0, node_opcua_assert_1.assert)(typeof Constructor === "function");
    (0, node_opcua_assert_1.assert)(options !== null && typeof options === "object");
    (0, node_opcua_assert_1.assert)(!extraInfo || (extraInfo !== null && typeof extraInfo === "object" && typeof extraInfo.registerClonedObject === "function"));
    (0, node_opcua_assert_1.assert)(!originalNode.subtypeOf, "We do not do cloning of Type yet");
    const namespace = options.namespace;
    const constructorOptions = {
        ...options,
        addressSpace: namespace.addressSpace,
        browseName: originalNode.browseName,
        description: originalNode.description,
        displayName: originalNode.displayName,
        nodeClass: originalNode.nodeClass
    };
    constructorOptions.references = options.references || [];
    if (originalNode.nodeClass === node_opcua_data_model_1.NodeClass.Variable || originalNode.nodeClass === node_opcua_data_model_1.NodeClass.Object) {
        const voThis = originalNode;
        if (voThis.typeDefinition) {
            constructorOptions.references.push(new reference_impl_1.ReferenceImpl({
                isForward: true,
                nodeId: voThis.typeDefinition,
                referenceType: (0, node_opcua_nodeid_1.resolveNodeId)("HasTypeDefinition")
            }));
        }
    }
    if (!constructorOptions.modellingRule) {
        if (originalNode.modellingRule && options.copyAlsoModellingRules) {
            const modellingRuleNode = originalNode.findReferencesAsObject("HasModellingRule", true)[0];
            (0, node_opcua_assert_1.assert)(modellingRuleNode);
            constructorOptions.references.push(new reference_impl_1.ReferenceImpl({
                isForward: true,
                nodeId: modellingRuleNode.nodeId,
                referenceType: (0, node_opcua_nodeid_1.resolveNodeId)("HasModellingRule")
            }));
        }
    }
    else {
        (0, namespace_private_1.UANamespace_process_modelling_rule)(constructorOptions.references, constructorOptions.modellingRule);
    }
    constructorOptions.nodeId = namespace.constructNodeId(constructorOptions);
    (0, node_opcua_assert_1.assert)(constructorOptions.nodeId instanceof node_opcua_nodeid_1.NodeId);
    const clonedNode = new Constructor(constructorOptions);
    originalNode.addressSpace._register(clonedNode);
    extraInfo.registerClonedObject({
        originalNode,
        clonedNode
    });
    if (!options.ignoreChildren) {
        // clone children and the rest ....
        options.copyAlsoModellingRules = options.copyAlsoModellingRules || false;
        const newFilter = optionalFilter.filterFor(clonedNode);
        const browseNameMap = new Set();
        _clone_hierarchical_references(originalNode, clonedNode, options.copyAlsoModellingRules, newFilter, extraInfo, browseNameMap);
        if (originalNode.nodeClass === node_opcua_data_model_1.NodeClass.Object || originalNode.nodeClass === node_opcua_data_model_1.NodeClass.Variable) {
            let typeDefinitionNode = originalNode.typeDefinitionObj;
            extraInfo.pushContext({
                clonedParent: clonedNode,
                originalParent: originalNode
            });
            while (typeDefinitionNode) {
                // istanbul ignore next
                doTrace &&
                    traceLog(extraInfo?.pad(), chalk_1.default.blueBright(originalNode.browseName.toString(), "-----> Exploring ", typeDefinitionNode.browseName.toString()));
                _clone_hierarchical_references(typeDefinitionNode, clonedNode, options.copyAlsoModellingRules, newFilter, extraInfo, browseNameMap);
                typeDefinitionNode = typeDefinitionNode.subtypeOfObj;
            }
            extraInfo.popContext();
        }
        _clone_non_hierarchical_references(originalNode, clonedNode, options.copyAlsoModellingRules, newFilter, extraInfo, browseNameMap);
    }
    clonedNode.propagate_back_references();
    clonedNode.install_extra_properties();
    return clonedNode;
}
function _add(_childByNameMap, reference) {
    (0, node_opcua_assert_1.assert)(reference.node); // const targetNode = ReferenceImpl.resolveReferenceNode(addressSpace, reference);
    const targetNode = reference.node;
    const hash = targetNode.browseName.name || "";
    const existing = _childByNameMap.get(hash);
    if (existing) {
        if (Array.isArray(existing)) {
            existing.push(reference);
        }
        else {
            _childByNameMap.set(hash, [existing, reference]);
        }
    }
    else {
        _childByNameMap.set(hash, reference);
    }
}
function sameRef(a, b) {
    if (a.isForward != b.isForward)
        return false;
    if (!(0, node_opcua_nodeid_1.sameNodeId)(a.nodeId, b.nodeId))
        return false;
    if (!(0, node_opcua_nodeid_1.sameNodeId)(a.referenceType, b.referenceType))
        return false;
    return true;
}
function _remove(_childByNameMap, reference) {
    const target = reference.node;
    const hash = target.browseName.name || "";
    const existing = _childByNameMap.get(hash);
    if (Array.isArray(existing)) {
        existing.filter(r => !sameRef(r, reference));
    }
    else {
        _childByNameMap.delete(hash);
    }
}
function _handle_HierarchicalReference(node, reference) {
    const _private = BaseNode_getPrivate(node);
    if (!reference.isForward)
        return;
    if (_private._childByNameMap) {
        const addressSpace = node.addressSpace;
        const referenceType = reference_impl_1.ReferenceImpl.resolveReferenceType(addressSpace, reference);
        if (referenceType) {
            const HierarchicalReferencesType = addressSpace.findReferenceType("HierarchicalReferences");
            if (referenceType.isSubtypeOf(HierarchicalReferencesType)) {
                reference_impl_1.ReferenceImpl.resolveReferenceNode(addressSpace, reference);
                _add(_private._childByNameMap, reference);
            }
        }
    }
}
function _get_HierarchicalReference(node) {
    const addressSpace = node.addressSpace;
    const _private = BaseNode_getPrivate(node);
    if (!_private._childByNameMap) {
        _private._childByNameMap = new Map();
        const references = node.findReferencesEx("HierarchicalReferences");
        for (var reference of references) {
            reference_impl_1.ReferenceImpl.resolveReferenceNode(addressSpace, reference);
            _add(_private._childByNameMap, reference);
        }
    }
    return _private._childByNameMap;
}
function _remove_HierarchicalReference(node, reference) {
    const _private = BaseNode_getPrivate(node);
    if (_private._childByNameMap && reference.isForward) {
        const addressSpace = node.addressSpace;
        const referenceType = reference_impl_1.ReferenceImpl.resolveReferenceType(addressSpace, reference);
        if (referenceType) {
            const HierarchicalReferencesType = addressSpace.findReferenceType("HierarchicalReferences");
            if (referenceType.isSubtypeOf(HierarchicalReferencesType)) {
                reference_impl_1.ReferenceImpl.resolveReferenceNode(addressSpace, reference);
                _remove(_private._childByNameMap, reference);
            }
        }
    }
}
function _makeReferenceDescription(addressSpace, reference, resultMask) {
    const isForward = reference.isForward;
    const referenceTypeId = reference_impl_1.ReferenceImpl.resolveReferenceType(addressSpace, reference).nodeId;
    (0, node_opcua_assert_1.assert)(referenceTypeId instanceof node_opcua_nodeid_1.NodeId);
    const obj = reference_impl_1.ReferenceImpl.resolveReferenceNode(addressSpace, reference);
    let data = {};
    if (!obj) {
        // cannot find reference node
        data = {
            isForward,
            nodeId: reference.nodeId,
            referenceTypeId: resultMask & node_opcua_data_model_1.ResultMask.ReferenceType ? referenceTypeId : null,
            typeDefinition: null
        };
    }
    else {
        (0, node_opcua_assert_1.assert)(reference.nodeId, " obj.nodeId");
        data = {
            browseName: resultMask & node_opcua_data_model_1.ResultMask.BrowseName ? (0, node_opcua_data_model_1.coerceQualifiedName)(obj.browseName) : null,
            displayName: resultMask & node_opcua_data_model_1.ResultMask.DisplayName ? (0, node_opcua_data_model_1.coerceLocalizedText)(obj.displayName[0]) : null,
            isForward: resultMask & node_opcua_data_model_1.ResultMask.IsForward ? isForward : false,
            nodeClass: resultMask & node_opcua_data_model_1.ResultMask.NodeClass ? obj.nodeClass : node_opcua_data_model_1.NodeClass.Unspecified,
            nodeId: obj.nodeId,
            referenceTypeId: resultMask & node_opcua_data_model_1.ResultMask.ReferenceType ? referenceTypeId : null,
            typeDefinition: resultMask & node_opcua_data_model_1.ResultMask.TypeDefinition ? obj.typeDefinition : null
        };
    }
    if (data.typeDefinition === null) {
        data.typeDefinition = new node_opcua_nodeid_1.NodeId();
    }
    const referenceDescription = new node_opcua_types_1.ReferenceDescription(data);
    return referenceDescription;
}
function _constructReferenceDescription(addressSpace, references, resultMask) {
    (0, node_opcua_assert_1.assert)(Array.isArray(references));
    return references.map((reference) => _makeReferenceDescription(addressSpace, reference, resultMask));
}
function BaseNode_remove_backward_reference(reference) {
    const _private = BaseNode_getPrivate(this);
    _remove_HierarchicalReference(this, reference);
    const h = reference.hash;
    if (_private._back_referenceIdx?.has(h)) {
        // note : h may not exist in _back_referenceIdx since we are not indexing
        //        _back_referenceIdx to UAObjectType and UAVariableType for performance reasons
        _private._back_referenceIdx.get(h).dispose();
        _private._back_referenceIdx.delete(h);
    }
    reference.dispose();
}
function BaseNode_add_backward_reference(reference) {
    const _private = BaseNode_getPrivate(this);
    const h = reference.hash;
    (0, node_opcua_assert_1.assert)(typeof h === "string");
    // istanbul ignore next
    if (_private._referenceIdx.has(h)) {
        //  the reference exists already in the forward references
        //  this append for instance when the XML NotSetFile has redundant <UAReference>
        //  in this case there is nothing to do
        return;
    }
    // istanbul ignore next
    if (_private._back_referenceIdx.has(h)) {
        const opts = { addressSpace: this.addressSpace };
        warningLog(" Warning !", this.browseName.toString());
        warningLog("    ", reference.toString(opts));
        warningLog(" already found in ===>");
        warningLog([..._private._back_referenceIdx.values()].map((c) => c.toString(opts)).join("\n"));
        // tslint:disable-next-line:no-console
        warningLog("===>");
        throw new Error("reference exists already in _back_references");
    }
    if (!(0, base_node_impl_1.getReferenceType)(reference)) {
        const stop_here = 1;
    }
    //  assert(reference._referenceType instanceof ReferenceType);
    _private._back_referenceIdx.set(h, reference);
    _handle_HierarchicalReference(this, reference);
    BaseNode_clearCache(this);
}
//# sourceMappingURL=base_node_private.js.map