"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.implementInterfaceBad = implementInterfaceBad;
exports.implementInterface = implementInterface;
const node_opcua_data_model_1 = require("node-opcua-data-model");
const _instantiate_helpers_1 = require("../src/_instantiate_helpers");
function implementInterfaceBad(uaNode, interfaceType) {
    const addressSpace = uaNode.addressSpace;
    const tmp = interfaceType.instantiate({
        browseName: uaNode.browseName,
        copyAlsoModellingRules: true,
        copyAlsoAllOptionals: true,
        modellingRule: "Mandatory"
    });
    // 
    uaNode.addReference({
        nodeId: interfaceType,
        referenceType: "HasInterface"
    });
    const childrenRef = tmp.findReferencesEx("HasChild", node_opcua_data_model_1.BrowseDirection.Forward);
    // transfer children to uaNode
    for (const childRef of childrenRef) {
        tmp.removeReference({
            nodeId: childRef.nodeId,
            referenceType: childRef.referenceType,
            isForward: childRef.isForward
        });
        uaNode.addReference({
            nodeId: childRef.nodeId,
            referenceType: childRef.referenceType,
            isForward: childRef.isForward
        });
    }
    addressSpace.deleteNode(tmp);
}
function implementInterface(uaNode, interfaceType) {
    const addressSpace = uaNode.addressSpace;
    const topMost = addressSpace.findObjectType("BaseInterfaceType");
    (0, _instantiate_helpers_1.initialize_properties_and_components)(uaNode, topMost, interfaceType, true, true, []);
    uaNode.addReference({
        nodeId: interfaceType,
        referenceType: "HasInterface"
    });
}
//# sourceMappingURL=ua_interface.js.map