"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.instantiateAddIn = instantiateAddIn;
exports.addDefaultInstanceBrowseName = addDefaultInstanceBrowseName;
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const node_opcua_data_model_1 = require("node-opcua-data-model");
function instantiateAddIn(objectType, options) {
    let defaultName = options.defaultName;
    // check that objectType has he shape of an addInd
    const defaultInstanceBrowseName = objectType.getPropertyByName("DefaultInstanceBrowseName");
    if (!defaultInstanceBrowseName) {
        throw new Error("objectType must have a DefaultInstanceBrowseName property");
    }
    const browseName = (0, node_opcua_data_model_1.coerceQualifiedName)(defaultName || defaultInstanceBrowseName.readValue().value.value);
    const addIn = objectType.instantiate({
        namespace: options.namespace || objectType.namespace,
        browseName: browseName,
        modellingRule: options.modellingRule,
        copyAlsoModellingRules: options.copyAlsoModellingRules,
        addInOf: options.addInOf,
        nodeId: options.nodeId
    });
    return addIn;
}
function addDefaultInstanceBrowseName(objectType, defaultBrowseName) {
    const namespace1 = objectType.namespace;
    if (typeof defaultBrowseName === "string") {
        defaultBrowseName = (0, node_opcua_data_model_1.coerceQualifiedName)({ name: defaultBrowseName, namespaceIndex: namespace1.index });
    }
    const uaVaraible = namespace1.addVariable({
        browseName: (0, node_opcua_data_model_1.coerceQualifiedName)({ name: "DefaultInstanceBrowseName", namespaceIndex: 0 }),
        propertyOf: objectType,
        typeDefinition: "PropertyType",
        dataType: node_opcua_basic_types_1.DataType.QualifiedName,
        value: {
            dataType: node_opcua_basic_types_1.DataType.QualifiedName,
            value: defaultBrowseName
        },
        modellingRule: null // DefaultInstanceBrowseName must have no ModellingRule
    });
    return uaVaraible;
}
//# sourceMappingURL=ua_addin.js.map