import { DataValue } from "node-opcua-data-value";
import { NodeId } from "node-opcua-nodeid";
import { ArgumentDefinition, BrowseDescriptionLike, CallMethodRequestLike, IBasicSession, MethodId, ResponseCallback } from "node-opcua-pseudo-session";
import { BrowseResult } from "node-opcua-service-browse";
import { CallMethodResult } from "node-opcua-service-call";
import { BrowsePath, BrowsePathResult } from "node-opcua-service-translate-browse-path";
import { StatusCode } from "node-opcua-status-code";
import { WriteValueOptions, ReadValueIdOptions, BrowseDescriptionOptions } from "node-opcua-types";
import { IAddressSpace, ISessionContext } from "node-opcua-address-space-base";
import { ContinuationPointManager } from "./continuation_points/continuation_point_manager";
export interface InnerBrowseEngine {
    requestedMaxReferencesPerNode: number;
    maxBrowseContinuationPoints: number;
    continuationPointManager: ContinuationPointManager;
    context: ISessionContext;
    browseAll: (nodesToBrowse: BrowseDescriptionOptions[], callback: ResponseCallback<BrowseResult[]>) => void;
}
export declare function innerBrowse(engine: InnerBrowseEngine, nodesToBrowse: BrowseDescriptionOptions[], callback?: ResponseCallback<BrowseResult[]>): void;
export interface InnerBrowseNextEngine {
    continuationPointManager: ContinuationPointManager;
}
export declare function innerBrowseNext(engine: InnerBrowseNextEngine, continuationPoints: Buffer[], releaseContinuationPoints: boolean, callback?: ResponseCallback<BrowseResult[]>): void;
declare const $addressSpace: unique symbol;
declare const $context: unique symbol;
/**
 * Pseudo session is an helper object that exposes the same async methods
 * than the ClientSession. It can be used on a server address space.
 *
 * Code reused !
 * The primary benefit of this object  is that its makes advanced OPCUA
 * operations that uses browse, translate, read, write etc similar
 * whether we work inside a server or through a client session.
 *
 */
export declare class PseudoSession implements IBasicSession {
    requestedMaxReferencesPerNode: number;
    maxBrowseContinuationPoints: number;
    private _sessionId;
    private readonly [$addressSpace];
    private readonly continuationPointManager;
    private readonly [$context];
    constructor(addressSpace: IAddressSpace, context?: ISessionContext);
    getSessionId(): NodeId;
    browse(nodeToBrowse: BrowseDescriptionLike, callback: ResponseCallback<BrowseResult>): void;
    browse(nodesToBrowse: BrowseDescriptionLike[], callback: ResponseCallback<BrowseResult[]>): void;
    browse(nodeToBrowse: BrowseDescriptionLike): Promise<BrowseResult>;
    browse(nodesToBrowse: BrowseDescriptionLike[]): Promise<BrowseResult[]>;
    read(nodeToRead: ReadValueIdOptions, callback: ResponseCallback<DataValue>): void;
    read(nodesToRead: ReadValueIdOptions[], callback: ResponseCallback<DataValue[]>): void;
    read(nodeToRead: ReadValueIdOptions): Promise<DataValue>;
    read(nodesToRead: ReadValueIdOptions[]): Promise<DataValue[]>;
    browseNext(continuationPoint: Buffer, releaseContinuationPoints: boolean, callback: ResponseCallback<BrowseResult>): void;
    browseNext(continuationPoints: Buffer[], releaseContinuationPoints: boolean, callback: ResponseCallback<BrowseResult[]>): void;
    browseNext(continuationPoint: Buffer, releaseContinuationPoints: boolean): Promise<BrowseResult>;
    browseNext(continuationPoints: Buffer[], releaseContinuationPoints: boolean): Promise<BrowseResult[]>;
    call(methodToCall: CallMethodRequestLike, callback: ResponseCallback<CallMethodResult>): void;
    call(methodsToCall: CallMethodRequestLike[], callback: ResponseCallback<CallMethodResult[]>): void;
    call(methodToCall: CallMethodRequestLike): Promise<CallMethodResult>;
    call(methodsToCall: CallMethodRequestLike[]): Promise<CallMethodResult[]>;
    getArgumentDefinition(methodId: MethodId): Promise<ArgumentDefinition>;
    getArgumentDefinition(methodId: MethodId, callback: ResponseCallback<ArgumentDefinition>): void;
    translateBrowsePath(browsePaths: BrowsePath[], callback: ResponseCallback<BrowsePathResult[]>): void;
    translateBrowsePath(browsePath: BrowsePath, callback: ResponseCallback<BrowsePathResult>): void;
    translateBrowsePath(browsePath: BrowsePath): Promise<BrowsePathResult>;
    translateBrowsePath(browsePaths: BrowsePath[]): Promise<BrowsePathResult[]>;
    write(nodeToWrite: WriteValueOptions, callback: ResponseCallback<StatusCode>): void;
    write(nodesToWrite: WriteValueOptions[], callback: ResponseCallback<StatusCode[]>): void;
    write(nodeToWrite: WriteValueOptions): Promise<StatusCode>;
    write(nodesToWrite: WriteValueOptions[]): Promise<StatusCode[]>;
}
export {};
