"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeQualifiedNameParser = void 0;
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const makeQualifiedNameParser = (_translateNodeId) => ({
    QualifiedName: {
        init() {
            this.qualifiedName = {
                namespaceIndex: 0,
                name: null
            };
            this.value = null;
        },
        parser: {
            Name: {
                finish() {
                    this.parent.qualifiedName.name = this.text.trim();
                }
            },
            NamespaceIndex: {
                finish() {
                    const ns = parseInt(this.text, 10);
                    const t = _translateNodeId((0, node_opcua_nodeid_1.resolveNodeId)(`ns=${ns};i=1`).toString());
                    this.parent.qualifiedName.namespaceIndex = t.namespace;
                }
            }
        },
        finish() {
            this.value = (0, node_opcua_data_model_1.coerceQualifiedName)(this.qualifiedName);
        }
    }
});
exports.makeQualifiedNameParser = makeQualifiedNameParser;
//# sourceMappingURL=qualified_name_parser.js.map