"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeNodeIdParser = void 0;
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const makeNodeIdParser = (_translateNodeId) => ({
    NodeId: {
        init() {
            this.nodeId = "";
        },
        parser: {
            Identifier: {
                finish() {
                    this.parent.nodeId = _translateNodeId((0, node_opcua_nodeid_1.resolveNodeId)(this.text.trim()).toString());
                }
            }
        }
    }
});
exports.makeNodeIdParser = makeNodeIdParser;
//# sourceMappingURL=nodeid_parser.js.map