import { IAddressSpace } from "node-opcua-address-space-base";
import { ExtensionObject } from "node-opcua-extension-object";
import { NodeId } from "node-opcua-nodeid";
import { InternalFragmentClonerReaderState, ParserLike, ReaderStateParserLike } from "node-opcua-xml2json";
import { Argument, EnumValueType, EUInformationOptions } from "node-opcua-types";
import { Range } from "node-opcua-data-access";
export type Task = (addressSpace: IAddressSpace) => Promise<void>;
type ArgumentParser = ParserLike & {
    argument: Argument;
};
type RangeParser = ParserLike & {
    range: Range;
};
type EUInformationParser = ReaderStateParserLike & {
    euInformation: EUInformationOptions;
    parser: any;
};
type EnumValueParser = ReaderStateParserLike & {
    enumValueType: EnumValueType;
    parser: {
        Value: ReaderStateParserLike;
        DisplayName: ReaderStateParserLike;
        Description: ReaderStateParserLike;
    };
};
export interface ExtensionObjectTypeIdParser {
    parent: ExtensionObjectParser;
}
export interface ExtensionObjectTypeIdIdentifierParser {
    text: string;
    parent: ExtensionObjectTypeIdParser;
}
export interface ExtensionObjectParserInner {
    typeDefinitionId: NodeId;
}
type ExtensionObjectParser = ExtensionObjectParserInner & any;
export interface ExtensionObjectBodyParser {
    parent: ExtensionObjectParser;
    _cloneFragment: InternalFragmentClonerReaderState;
    engine: any;
    parser: {
        Argument: ArgumentParser;
        EUInformation: EUInformationParser;
        EnumValueType: EnumValueParser;
        Range: RangeParser;
    };
}
export declare function makeExtensionObjectInnerParser<T>(translateNodeId: (nodeId: string) => NodeId, setExtensionObject: (extensionObject: ExtensionObject) => void, setExtensionObjectPojo: (typeDefinition: NodeId, xmlData: string, data: T) => void): ReaderStateParserLike;
export declare function makeExtensionObjectParser<T>(translateNodeId: (nodeId: string) => NodeId, setExtensionObject: (extensionObject: ExtensionObject, data: T) => void, setExtensionObjectPojo: (typeDefinition: NodeId, xmlData: string, data: T) => void): ParserLike;
export declare function createXMLExtensionObjectDecodingTask(translateNodeId: (nodeId: string) => NodeId, xmlEncodingNodeId: NodeId, bodyXML: string, withDecoded: (extensionObject: ExtensionObject) => void): (addressSpace2: IAddressSpace) => Promise<void>;
export {};
